/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.ArrayList;

public class PrefHelper {
    public static final boolean LOG = false;
    public static final String NO_STRING_VALUE = "bnc_no_value";
    private static final String SHARED_PREF_FILE = "branch_referral_shared_pref";
    private static final String KEY_APP_KEY = "bnc_app_key";
    private static final String KEY_DEVICE_FINGERPRINT_ID = "bnc_device_fingerprint_id";
    private static final String KEY_SESSION_ID = "bnc_session_id";
    private static final String KEY_IDENTITY_ID = "bnc_identity_id";
    private static final String KEY_IDENTITY = "bnc_identity";
    private static final String KEY_LINK_CLICK_ID = "bnc_link_click_id";
    private static final String KEY_LINK_CLICK_IDENTIFIER = "bnc_link_click_identifier";
    private static final String KEY_SESSION_PARAMS = "bnc_session_params";
    private static final String KEY_INSTALL_PARAMS = "bnc_install_params";
    private static final String KEY_USER_URL = "bnc_user_url";
    private static final String KEY_IS_REFERRABLE = "bnc_is_referrable";
    private static final String KEY_BUCKETS = "bnc_buckets";
    private static final String KEY_CREDIT_BASE = "bnc_credit_base_";
    private static final String KEY_ACTIONS = "bnc_actions";
    private static final String KEY_TOTAL_BASE = "bnc_total_base_";
    private static final String KEY_UNIQUE_BASE = "bnc_balance_base_";
    private static PrefHelper prefHelper_;
    private SharedPreferences appSharedPrefs_;
    private SharedPreferences.Editor prefsEditor_;

    public PrefHelper() {
    }

    private PrefHelper(Context context) {
        this.appSharedPrefs_ = context.getSharedPreferences(SHARED_PREF_FILE, 0);
        this.prefsEditor_ = this.appSharedPrefs_.edit();
    }

    public static PrefHelper getInstance(Context context) {
        if (prefHelper_ == null) {
            prefHelper_ = new PrefHelper(context);
        }
        return prefHelper_;
    }

    public String getAPIBaseUrl() {
        return "https://api.branch.io/";
    }

    public void setAppKey(String key) {
        this.setString(KEY_APP_KEY, key);
    }

    public String getAppKey() {
        return this.getString(KEY_APP_KEY);
    }

    public void setDeviceFingerPrintID(String device_fingerprint_id) {
        this.setString(KEY_DEVICE_FINGERPRINT_ID, device_fingerprint_id);
    }

    public String getDeviceFingerPrintID() {
        return this.getString(KEY_DEVICE_FINGERPRINT_ID);
    }

    public void setSessionID(String session_id) {
        this.setString(KEY_SESSION_ID, session_id);
    }

    public String getSessionID() {
        return this.getString(KEY_SESSION_ID);
    }

    public void setIdentityID(String identity_id) {
        this.setString(KEY_IDENTITY_ID, identity_id);
    }

    public String getIdentityID() {
        return this.getString(KEY_IDENTITY_ID);
    }

    public void setIdentity(String identity) {
        this.setString(KEY_IDENTITY, identity);
    }

    public String getIdentity() {
        return this.getString(KEY_IDENTITY);
    }

    public void setLinkClickID(String link_click_id) {
        this.setString(KEY_LINK_CLICK_ID, link_click_id);
    }

    public String getLinkClickID() {
        return this.getString(KEY_LINK_CLICK_ID);
    }

    public void setLinkClickIdentifier(String identifer) {
        this.setString(KEY_LINK_CLICK_IDENTIFIER, identifer);
    }

    public String getLinkClickIdentifier() {
        return this.getString(KEY_LINK_CLICK_IDENTIFIER);
    }

    public String getSessionParams() {
        return this.getString(KEY_SESSION_PARAMS);
    }

    public void setSessionParams(String params) {
        this.setString(KEY_SESSION_PARAMS, params);
    }

    public String getInstallParams() {
        return this.getString(KEY_INSTALL_PARAMS);
    }

    public void setInstallParams(String params) {
        this.setString(KEY_INSTALL_PARAMS, params);
    }

    public void setUserURL(String user_url) {
        this.setString(KEY_USER_URL, user_url);
    }

    public String getUserURL() {
        return this.getString(KEY_USER_URL);
    }

    public int getIsReferrable() {
        return this.getInteger(KEY_IS_REFERRABLE);
    }

    public void setIsReferrable() {
        this.setInteger(KEY_IS_REFERRABLE, 1);
    }

    public void clearIsReferrable() {
        this.setInteger(KEY_IS_REFERRABLE, 0);
    }

    public void clearUserValues() {
        ArrayList<String> buckets = this.getBuckets();
        for (String bucket : buckets) {
            this.setCreditCount(bucket, 0);
        }
        this.setBuckets(new ArrayList<String>());
        ArrayList<String> actions = this.getActions();
        for (String action : actions) {
            this.setActionTotalCount(action, 0);
            this.setActionUniqueCount(action, 0);
        }
        this.setActions(new ArrayList<String>());
    }

    private ArrayList<String> getBuckets() {
        String bucketList = this.getString(KEY_BUCKETS);
        if (bucketList.equals(NO_STRING_VALUE)) {
            return new ArrayList<String>();
        }
        return this.deserializeString(bucketList);
    }

    private void setBuckets(ArrayList<String> buckets) {
        if (buckets.size() == 0) {
            this.setString(KEY_BUCKETS, NO_STRING_VALUE);
        } else {
            this.setString(KEY_BUCKETS, this.serializeArrayList(buckets));
        }
    }

    public void setCreditCount(int count) {
        this.setCreditCount("default", count);
    }

    public void setCreditCount(String bucket, int count) {
        ArrayList<String> buckets = this.getBuckets();
        if (!buckets.contains(bucket)) {
            buckets.add(bucket);
            this.setBuckets(buckets);
        }
        this.setInteger(KEY_CREDIT_BASE + bucket, count);
    }

    public int getCreditCount() {
        return this.getCreditCount("default");
    }

    public int getCreditCount(String bucket) {
        return this.getInteger(KEY_CREDIT_BASE + bucket);
    }

    private ArrayList<String> getActions() {
        String actionList = this.getString(KEY_ACTIONS);
        if (actionList.equals(NO_STRING_VALUE)) {
            return new ArrayList<String>();
        }
        return this.deserializeString(actionList);
    }

    private void setActions(ArrayList<String> actions) {
        if (actions.size() == 0) {
            this.setString(KEY_ACTIONS, NO_STRING_VALUE);
        } else {
            this.setString(KEY_ACTIONS, this.serializeArrayList(actions));
        }
    }

    public void setActionTotalCount(String action, int count) {
        ArrayList<String> actions = this.getActions();
        if (!actions.contains(action)) {
            actions.add(action);
            this.setActions(actions);
        }
        this.setInteger(KEY_TOTAL_BASE + action, count);
    }

    public void setActionUniqueCount(String action, int count) {
        this.setInteger(KEY_UNIQUE_BASE + action, count);
    }

    public int getActionTotalCount(String action) {
        return this.getInteger(KEY_TOTAL_BASE + action);
    }

    public int getActionUniqueCount(String action) {
        return this.getInteger(KEY_UNIQUE_BASE + action);
    }

    private String serializeArrayList(ArrayList<String> strings) {
        String retString = "";
        for (String value : strings) {
            retString = String.valueOf(retString) + value + ",";
        }
        retString = retString.substring(0, retString.length() - 1);
        return retString;
    }

    private ArrayList<String> deserializeString(String list) {
        ArrayList<String> strings = new ArrayList<String>();
        String[] stringArr = list.split(",");
        int i = 0;
        while (i < stringArr.length) {
            strings.add(stringArr[i]);
            ++i;
        }
        return strings;
    }

    public int getInteger(String key) {
        return PrefHelper.prefHelper_.appSharedPrefs_.getInt(key, 0);
    }

    public long getLong(String key) {
        return PrefHelper.prefHelper_.appSharedPrefs_.getLong(key, 0L);
    }

    public float getFloat(String key) {
        return PrefHelper.prefHelper_.appSharedPrefs_.getFloat(key, 0.0f);
    }

    public String getString(String key) {
        return PrefHelper.prefHelper_.appSharedPrefs_.getString(key, NO_STRING_VALUE);
    }

    public boolean getBool(String key) {
        return PrefHelper.prefHelper_.appSharedPrefs_.getBoolean(key, false);
    }

    public void setInteger(String key, int value) {
        PrefHelper.prefHelper_.prefsEditor_.putInt(key, value);
        PrefHelper.prefHelper_.prefsEditor_.commit();
    }

    public void setLong(String key, long value) {
        PrefHelper.prefHelper_.prefsEditor_.putLong(key, value);
        PrefHelper.prefHelper_.prefsEditor_.commit();
    }

    public void setFloat(String key, float value) {
        PrefHelper.prefHelper_.prefsEditor_.putFloat(key, value);
        PrefHelper.prefHelper_.prefsEditor_.commit();
    }

    public void setString(String key, String value) {
        PrefHelper.prefHelper_.prefsEditor_.putString(key, value);
        PrefHelper.prefHelper_.prefsEditor_.commit();
    }

    public void setBool(String key, Boolean value) {
        PrefHelper.prefHelper_.prefsEditor_.putBoolean(key, value.booleanValue());
        PrefHelper.prefHelper_.prefsEditor_.commit();
    }
}

