/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.util.DisplayMetrics;
import io.branch.referral.NetworkCallback;
import io.branch.referral.PrefHelper;
import io.branch.referral.RemoteInterface;
import io.branch.referral.SystemObserver;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class BranchRemoteInterface
extends RemoteInterface {
    public static final String REQ_TAG_REGISTER_INSTALL = "t_register_install";
    public static final String REQ_TAG_REGISTER_OPEN = "t_register_open";
    public static final String REQ_TAG_REGISTER_CLOSE = "t_register_close";
    public static final String REQ_TAG_COMPLETE_ACTION = "t_complete_action";
    public static final String REQ_TAG_GET_REFERRAL_COUNTS = "t_get_referral_counts";
    public static final String REQ_TAG_GET_REWARDS = "t_get_rewards";
    public static final String REQ_TAG_REDEEM_REWARDS = "t_redeem_rewards";
    public static final String REQ_TAG_GET_REWARD_HISTORY = "t_get_reward_history";
    public static final String REQ_TAG_GET_CUSTOM_URL = "t_get_custom_url";
    public static final String REQ_TAG_IDENTIFY = "t_identify_user";
    public static final String REQ_TAG_LOGOUT = "t_logout";
    public static final String REQ_TAG_GET_REFERRAL_CODE = "t_get_referral_code";
    public static final String REQ_TAG_VALIDATE_REFERRAL_CODE = "t_validate_referral_code";
    public static final String REQ_TAG_APPLY_REFERRAL_CODE = "t_apply_referral_code";
    private SystemObserver sysObserver_;
    private PrefHelper prefHelper_;
    private NetworkCallback callback_;

    public BranchRemoteInterface() {
    }

    public BranchRemoteInterface(Context context) {
        this.prefHelper_ = PrefHelper.getInstance(context);
        this.sysObserver_ = new SystemObserver(context);
    }

    public void setNetworkCallbackListener(NetworkCallback callback) {
        this.callback_ = callback;
    }

    public void registerInstall(String installID, boolean debug) {
        String urlExtend = "v1/install";
        if (this.callback_ != null) {
            JSONObject installPost = new JSONObject();
            try {
                String uriScheme;
                installPost.put("app_id", (Object)this.prefHelper_.getAppKey());
                if (!installID.equals("bnc_no_value")) {
                    installPost.put("link_click_id", (Object)installID);
                }
                if (!this.sysObserver_.getUniqueID().equals("bnc_no_value")) {
                    installPost.put("hardware_id", (Object)this.sysObserver_.getUniqueID());
                    installPost.put("is_hardware_id_real", this.sysObserver_.hasRealHardwareId());
                }
                if (!this.sysObserver_.getAppVersion().equals("bnc_no_value")) {
                    installPost.put("app_version", (Object)this.sysObserver_.getAppVersion());
                }
                if (!this.sysObserver_.getCarrier().equals("bnc_no_value")) {
                    installPost.put("carrier", (Object)this.sysObserver_.getCarrier());
                }
                installPost.put("bluetooth", this.sysObserver_.getBluetoothPresent());
                if (!this.sysObserver_.getBluetoothVersion().equals("bnc_no_value")) {
                    installPost.put("bluetooth_version", (Object)this.sysObserver_.getBluetoothVersion());
                }
                installPost.put("has_nfc", this.sysObserver_.getNFCPresent());
                installPost.put("has_telephone", this.sysObserver_.getTelephonePresent());
                if (!this.sysObserver_.getPhoneBrand().equals("bnc_no_value")) {
                    installPost.put("brand", (Object)this.sysObserver_.getPhoneBrand());
                }
                if (!this.sysObserver_.getPhoneModel().equals("bnc_no_value")) {
                    installPost.put("model", (Object)this.sysObserver_.getPhoneModel());
                }
                if (!this.sysObserver_.getOS().equals("bnc_no_value")) {
                    installPost.put("os", (Object)this.sysObserver_.getOS());
                }
                if (!(uriScheme = this.sysObserver_.getURIScheme()).equals("bnc_no_value")) {
                    installPost.put("uri_scheme", (Object)uriScheme);
                }
                installPost.put("os_version", this.sysObserver_.getOSVersion());
                DisplayMetrics dMetrics = this.sysObserver_.getScreenDisplay();
                installPost.put("screen_dpi", dMetrics.densityDpi);
                installPost.put("screen_height", dMetrics.heightPixels);
                installPost.put("screen_width", dMetrics.widthPixels);
                installPost.put("wifi", this.sysObserver_.getWifiConnected());
                installPost.put("is_referrable", this.prefHelper_.getIsReferrable());
                installPost.put("update", this.sysObserver_.getUpdateState());
                if (!this.prefHelper_.getLinkClickIdentifier().equals("bnc_no_value")) {
                    installPost.put("link_identifier", (Object)this.prefHelper_.getLinkClickIdentifier());
                }
                installPost.put("debug", debug);
            }
            catch (JSONException ex) {
                ex.printStackTrace();
            }
            this.callback_.finished(this.make_restful_post(installPost, String.valueOf(this.prefHelper_.getAPIBaseUrl()) + urlExtend, REQ_TAG_REGISTER_INSTALL));
        }
    }

    public void registerOpen(boolean debug) {
        String urlExtend = "v1/open";
        if (this.callback_ != null) {
            JSONObject openPost = new JSONObject();
            try {
                openPost.put("app_id", (Object)this.prefHelper_.getAppKey());
                openPost.put("device_fingerprint_id", (Object)this.prefHelper_.getDeviceFingerPrintID());
                openPost.put("identity_id", (Object)this.prefHelper_.getIdentityID());
                openPost.put("is_referrable", this.prefHelper_.getIsReferrable());
                if (!this.sysObserver_.getAppVersion().equals("bnc_no_value")) {
                    openPost.put("app_version", (Object)this.sysObserver_.getAppVersion());
                }
                openPost.put("os_version", this.sysObserver_.getOSVersion());
                String uriScheme = this.sysObserver_.getURIScheme();
                if (!uriScheme.equals("bnc_no_value")) {
                    openPost.put("uri_scheme", (Object)uriScheme);
                }
                if (!this.sysObserver_.getOS().equals("bnc_no_value")) {
                    openPost.put("os", (Object)this.sysObserver_.getOS());
                }
                if (!this.prefHelper_.getLinkClickIdentifier().equals("bnc_no_value")) {
                    openPost.put("link_identifier", (Object)this.prefHelper_.getLinkClickIdentifier());
                }
                openPost.put("debug", debug);
            }
            catch (JSONException ex) {
                ex.printStackTrace();
            }
            this.callback_.finished(this.make_restful_post(openPost, String.valueOf(this.prefHelper_.getAPIBaseUrl()) + urlExtend, REQ_TAG_REGISTER_OPEN));
        }
    }

    public void registerClose() {
        String urlExtend = "v1/close";
        if (this.callback_ != null) {
            JSONObject closePost = new JSONObject();
            try {
                closePost.put("app_id", (Object)this.prefHelper_.getAppKey());
                closePost.put("session_id", (Object)this.prefHelper_.getSessionID());
            }
            catch (JSONException ex) {
                ex.printStackTrace();
            }
            this.callback_.finished(this.make_restful_post(closePost, String.valueOf(this.prefHelper_.getAPIBaseUrl()) + urlExtend, REQ_TAG_REGISTER_CLOSE));
        }
    }

    public void userCompletedAction(JSONObject post) {
        String urlExtend = "v1/event";
        if (this.callback_ != null) {
            this.callback_.finished(this.make_restful_post(post, String.valueOf(this.prefHelper_.getAPIBaseUrl()) + urlExtend, REQ_TAG_COMPLETE_ACTION));
        }
    }

    public void redeemRewards(JSONObject post) {
        String urlExtend = "v1/redeem";
        if (this.callback_ != null) {
            this.callback_.finished(this.make_restful_post(post, String.valueOf(this.prefHelper_.getAPIBaseUrl()) + urlExtend, REQ_TAG_REDEEM_REWARDS));
        }
    }

    public void getRewards() {
        String urlExtend = "v1/credits/" + this.prefHelper_.getIdentityID();
        if (this.callback_ != null) {
            this.callback_.finished(this.make_restful_get(String.valueOf(this.prefHelper_.getAPIBaseUrl()) + urlExtend, REQ_TAG_GET_REWARDS));
        }
    }

    public void getReferralCounts() {
        String urlExtend = "v1/referrals/" + this.prefHelper_.getIdentityID();
        if (this.callback_ != null) {
            this.callback_.finished(this.make_restful_get(String.valueOf(this.prefHelper_.getAPIBaseUrl()) + urlExtend, REQ_TAG_GET_REFERRAL_COUNTS));
        }
    }

    public void getCreditHistory(JSONObject post) {
        String params = this.convertJSONtoString(post);
        String urlExtend = "v1/credithistory" + params;
        if (this.callback_ != null) {
            this.callback_.finished(this.make_restful_get(String.valueOf(this.prefHelper_.getAPIBaseUrl()) + urlExtend, REQ_TAG_GET_REWARD_HISTORY));
        }
    }

    public void createCustomUrl(JSONObject post) {
        String urlExtend = "v1/url";
        if (this.callback_ != null) {
            this.callback_.finished(this.make_restful_post(post, String.valueOf(this.prefHelper_.getAPIBaseUrl()) + urlExtend, REQ_TAG_GET_CUSTOM_URL));
        }
    }

    public void identifyUser(JSONObject post) {
        String urlExtend = "v1/profile";
        if (this.callback_ != null) {
            this.callback_.finished(this.make_restful_post(post, String.valueOf(this.prefHelper_.getAPIBaseUrl()) + urlExtend, REQ_TAG_IDENTIFY));
        }
    }

    public void logoutUser(JSONObject post) {
        String urlExtend = "v1/logout";
        if (this.callback_ != null) {
            this.callback_.finished(this.make_restful_post(post, String.valueOf(this.prefHelper_.getAPIBaseUrl()) + urlExtend, REQ_TAG_LOGOUT));
        }
    }

    public void getReferralCode(JSONObject post) {
        String urlExtend = "v1/referralcode";
        if (this.callback_ != null) {
            this.callback_.finished(this.make_restful_post(post, String.valueOf(this.prefHelper_.getAPIBaseUrl()) + urlExtend, REQ_TAG_GET_REFERRAL_CODE));
        }
    }

    public void validateReferralCode(JSONObject post) {
        try {
            String urlExtend = "v1/referralcode/" + post.getString("referral_code");
            if (this.callback_ != null) {
                this.callback_.finished(this.make_restful_post(post, String.valueOf(this.prefHelper_.getAPIBaseUrl()) + urlExtend, REQ_TAG_VALIDATE_REFERRAL_CODE));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void applyReferralCode(JSONObject post) {
        try {
            String urlExtend = "v1/applycode/" + post.getString("referral_code");
            if (this.callback_ != null) {
                this.callback_.finished(this.make_restful_post(post, String.valueOf(this.prefHelper_.getAPIBaseUrl()) + urlExtend, REQ_TAG_APPLY_REFERRAL_CODE));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private String convertJSONtoString(JSONObject json) {
        Iterator iter;
        StringBuilder result = new StringBuilder();
        if (json != null && (iter = json.keys()).hasNext()) {
            boolean first = true;
            do {
                String value;
                if (first) {
                    result.append("?");
                    first = false;
                } else {
                    result.append("&");
                }
                String key = (String)iter.next();
                try {
                    value = json.getString(key);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return null;
                }
                result.append(String.valueOf(key) + "=" + value);
            } while (iter.hasNext());
        }
        return result.toString();
    }
}

