/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.text.format.DateFormat;
import android.util.Log;
import io.branch.referral.Base64;
import io.branch.referral.BranchRemoteInterface;
import io.branch.referral.NetworkCallback;
import io.branch.referral.PrefHelper;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerRequestQueue;
import io.branch.referral.ServerResponse;
import io.branch.referral.SystemObserver;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Branch {
    public static String FEATURE_TAG_SHARE = "share";
    public static String FEATURE_TAG_REFERRAL = "referral";
    public static String FEATURE_TAG_INVITE = "invite";
    public static String FEATURE_TAG_DEAL = "deal";
    public static String FEATURE_TAG_GIFT = "gift";
    public static String REDEEM_CODE = "$redeem_code";
    public static String REEFERRAL_BUCKET_DEFAULT = "default";
    public static String REFERRAL_CODE_TYPE = "credit";
    public static int REFERRAL_CREATION_SOURCE_SDK = 2;
    public static String REFERRAL_CODE = "referral_code";
    public static int REFERRAL_CODE_LOCATION_REFERREE = 0;
    public static int REFERRAL_CODE_LOCATION_REFERRING_USER = 2;
    public static int REFERRAL_CODE_LOCATION_BOTH = 3;
    public static int REFERRAL_CODE_AWARD_UNLIMITED = 1;
    public static int REFERRAL_CODE_AWARD_UNIQUE = 0;
    public static int LINK_TYPE_UNLIMITED_USE = 0;
    public static int LINK_TYPE_ONE_TIME_USE = 1;
    private static final int SESSION_KEEPALIVE = 5000;
    private static final int INTERVAL_RETRY = 3000;
    private static final int MAX_RETRIES = 5;
    private static Branch branchReferral_;
    private boolean isInit_;
    private BranchReferralInitListener initSessionFinishedCallback_;
    private BranchReferralInitListener initIdentityFinishedCallback_;
    private BranchReferralStateChangedListener stateChangedCallback_;
    private BranchLinkCreateListener linkCreateCallback_;
    private BranchListResponseListener creditHistoryCallback_;
    private BranchReferralInitListener getReferralCodeCallback_;
    private BranchReferralInitListener validateReferralCodeCallback_;
    private BranchReferralInitListener applyReferralCodeCallback_;
    private BranchRemoteInterface kRemoteInterface_;
    private PrefHelper prefHelper_;
    private SystemObserver systemObserver_;
    private Context context_;
    private Timer closeTimer;
    private boolean keepAlive_;
    private Semaphore serverSema_;
    private ServerRequestQueue requestQueue_;
    private int networkCount_;
    private int retryCount_;
    private boolean hasNetwork_;
    private boolean debug_;

    private Branch(Context context) {
        this.prefHelper_ = PrefHelper.getInstance(context);
        this.kRemoteInterface_ = new BranchRemoteInterface(context);
        this.systemObserver_ = new SystemObserver(context);
        this.kRemoteInterface_.setNetworkCallbackListener(new ReferralNetworkCallback());
        this.requestQueue_ = ServerRequestQueue.getInstance(context);
        this.serverSema_ = new Semaphore(1);
        this.closeTimer = new Timer();
        this.keepAlive_ = false;
        this.isInit_ = false;
        this.networkCount_ = 0;
        this.hasNetwork_ = true;
        this.debug_ = false;
    }

    public static Branch getInstance(Context context, String key) {
        if (branchReferral_ == null) {
            branchReferral_ = Branch.initInstance(context);
        }
        Branch.branchReferral_.context_ = context;
        Branch.branchReferral_.prefHelper_.setAppKey(key);
        return branchReferral_;
    }

    public static Branch getInstance(Context context) {
        if (branchReferral_ == null) {
            branchReferral_ = Branch.initInstance(context);
        }
        Branch.branchReferral_.context_ = context;
        return branchReferral_;
    }

    private static Branch initInstance(Context context) {
        return new Branch(context.getApplicationContext());
    }

    public void resetUserSession() {
        this.isInit_ = false;
    }

    public void setDebug() {
        this.debug_ = true;
    }

    @Deprecated
    public void initUserSession(BranchReferralInitListener callback) {
        this.initSession(callback);
    }

    public void initSession(BranchReferralInitListener callback) {
        if (this.systemObserver_.getUpdateState() == 0 && !this.hasUser()) {
            this.prefHelper_.setIsReferrable();
        } else {
            this.prefHelper_.clearIsReferrable();
        }
        this.initUserSessionInternal(callback);
    }

    @Deprecated
    public void initUserSession(BranchReferralInitListener callback, Uri data) {
        this.initSession(callback, data);
    }

    public void initSession(BranchReferralInitListener callback, Uri data) {
        if (data != null && data.getQueryParameter("link_click_id") != null) {
            this.prefHelper_.setLinkClickIdentifier(data.getQueryParameter("link_click_id"));
        }
        this.initSession(callback);
    }

    @Deprecated
    public void initUserSession() {
        this.initSession();
    }

    public void initSession() {
        this.initSession(null);
    }

    @Deprecated
    public void initUserSessionWithData(Uri data) {
        this.initSessionWithData(data);
    }

    public void initSessionWithData(Uri data) {
        if (data != null && data.getQueryParameter("link_click_id") != null) {
            this.prefHelper_.setLinkClickIdentifier(data.getQueryParameter("link_click_id"));
        }
        this.initSession(null);
    }

    @Deprecated
    public void initUserSession(boolean isReferrable) {
        this.initSession(isReferrable);
    }

    public void initSession(boolean isReferrable) {
        this.initSession(null, isReferrable);
    }

    @Deprecated
    public void initUserSession(BranchReferralInitListener callback, boolean isReferrable, Uri data) {
        this.initSession(callback, isReferrable, data);
    }

    public void initSession(BranchReferralInitListener callback, boolean isReferrable, Uri data) {
        if (data != null && data.getQueryParameter("link_click_id") != null) {
            this.prefHelper_.setLinkClickIdentifier(data.getQueryParameter("link_click_id"));
        }
        this.initSession(callback, isReferrable);
    }

    @Deprecated
    public void initUserSession(BranchReferralInitListener callback, boolean isReferrable) {
        this.initSession(callback, isReferrable);
    }

    public void initSession(BranchReferralInitListener callback, boolean isReferrable) {
        if (isReferrable) {
            this.prefHelper_.setIsReferrable();
        } else {
            this.prefHelper_.clearIsReferrable();
        }
        this.initUserSessionInternal(callback);
    }

    private void initUserSessionInternal(BranchReferralInitListener callback) {
        this.initSessionFinishedCallback_ = callback;
        if (!this.isInit_) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Branch.this.initializeSession();
                    Branch.this.recoverFromQueue();
                }
            }).start();
            this.isInit_ = true;
        } else {
            boolean installOrOpenInQueue = this.requestQueue_.containsInstallOrOpen();
            if (this.hasUser() && this.hasSession() && !installOrOpenInQueue) {
                if (callback != null) {
                    callback.onInitFinished(new JSONObject());
                }
                this.keepAlive();
            } else if (!installOrOpenInQueue) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Branch.this.initializeSession();
                        Branch.this.recoverFromQueue();
                    }
                }).start();
            } else {
                this.processNextQueueItem();
                this.recoverFromQueue();
            }
        }
    }

    private void recoverFromQueue() {
        int queueSize = this.requestQueue_.getSize();
        int i = 0;
        while (i < queueSize) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Branch.this.processNextQueueItem();
                }
            }).start();
            ++i;
        }
    }

    public void closeSession() {
        if (this.keepAlive_) {
            return;
        }
        this.isInit_ = false;
        if (!this.hasNetwork_) {
            ServerRequest req = this.requestQueue_.peek();
            if (req != null && (req.getTag().equals("t_register_install") || req.getTag().equals("t_register_open"))) {
                this.requestQueue_.dequeue();
            }
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Branch.this.requestQueue_.enqueue(new ServerRequest("t_register_close", null));
                    Branch.this.processNextQueueItem();
                }
            }).start();
        }
    }

    @Deprecated
    public void identifyUser(String userId, BranchReferralInitListener callback) {
        this.setIdentity(userId, callback);
    }

    public void setIdentity(String userId, BranchReferralInitListener callback) {
        this.initIdentityFinishedCallback_ = callback;
        this.setIdentity(userId);
    }

    @Deprecated
    public void identifyUser(String userId) {
        this.setIdentity(userId);
    }

    public void setIdentity(final String userId) {
        if (userId == null || userId.length() == 0) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                JSONObject post = new JSONObject();
                try {
                    post.put("app_id", (Object)Branch.this.prefHelper_.getAppKey());
                    post.put("identity_id", (Object)Branch.this.prefHelper_.getIdentityID());
                    post.put("identity", (Object)userId);
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                    return;
                }
                Branch.this.requestQueue_.enqueue(new ServerRequest("t_identify_user", post));
                Branch.this.processNextQueueItem();
            }
        }).start();
    }

    @Deprecated
    public void clearUser() {
        this.logout();
    }

    public void logout() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                JSONObject post = new JSONObject();
                try {
                    post.put("app_id", (Object)Branch.this.prefHelper_.getAppKey());
                    post.put("session_id", (Object)Branch.this.prefHelper_.getSessionID());
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                    return;
                }
                Branch.this.requestQueue_.enqueue(new ServerRequest("t_logout", post));
                Branch.this.processNextQueueItem();
            }
        }).start();
    }

    public void loadActionCounts() {
        this.loadActionCounts(null);
    }

    public void loadActionCounts(BranchReferralStateChangedListener callback) {
        this.stateChangedCallback_ = callback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Branch.this.requestQueue_.enqueue(new ServerRequest("t_get_referral_counts", null));
                Branch.this.processNextQueueItem();
            }
        }).start();
    }

    public void loadRewards() {
        this.loadRewards(null);
    }

    public void loadRewards(BranchReferralStateChangedListener callback) {
        this.stateChangedCallback_ = callback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Branch.this.requestQueue_.enqueue(new ServerRequest("t_get_rewards", null));
                Branch.this.processNextQueueItem();
            }
        }).start();
    }

    public int getCredits() {
        return this.prefHelper_.getCreditCount();
    }

    public int getCreditsForBucket(String bucket) {
        return this.prefHelper_.getCreditCount(bucket);
    }

    public int getTotalCountsForAction(String action) {
        return this.prefHelper_.getActionTotalCount(action);
    }

    public int getUniqueCountsForAction(String action) {
        return this.prefHelper_.getActionUniqueCount(action);
    }

    public void redeemRewards(int count) {
        this.redeemRewards("default", count);
    }

    public void redeemRewards(final String bucket, final int count) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int creditsToRedeem = 0;
                int credits = Branch.this.prefHelper_.getCreditCount(bucket);
                if (count > credits) {
                    creditsToRedeem = credits;
                    Log.i((String)"BranchSDK", (String)"Branch Warning: You're trying to redeem more credits than are available. Have you updated loaded rewards");
                } else {
                    creditsToRedeem = count;
                }
                if (creditsToRedeem > 0) {
                    Branch.this.retryCount_ = 0;
                    JSONObject post = new JSONObject();
                    try {
                        post.put("app_id", (Object)Branch.this.prefHelper_.getAppKey());
                        post.put("identity_id", (Object)Branch.this.prefHelper_.getIdentityID());
                        post.put("bucket", (Object)bucket);
                        post.put("amount", creditsToRedeem);
                    }
                    catch (JSONException ex) {
                        ex.printStackTrace();
                        return;
                    }
                    Branch.this.requestQueue_.enqueue(new ServerRequest("t_redeem_rewards", post));
                    Branch.this.processNextQueueItem();
                }
            }
        }).start();
    }

    public void getCreditHistory(BranchListResponseListener callback) {
        this.getCreditHistory(null, null, 100, CreditHistoryOrder.kMostRecentFirst, callback);
    }

    public void getCreditHistory(String bucket, BranchListResponseListener callback) {
        this.getCreditHistory(bucket, null, 100, CreditHistoryOrder.kMostRecentFirst, callback);
    }

    public void getCreditHistory(String afterId, int length, CreditHistoryOrder order, BranchListResponseListener callback) {
        this.getCreditHistory(null, afterId, length, order, callback);
    }

    public void getCreditHistory(final String bucket, final String afterId, final int length, final CreditHistoryOrder order, BranchListResponseListener callback) {
        this.creditHistoryCallback_ = callback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                JSONObject post = new JSONObject();
                try {
                    post.put("app_id", (Object)Branch.this.prefHelper_.getAppKey());
                    post.put("identity_id", (Object)Branch.this.prefHelper_.getIdentityID());
                    post.put("length", length);
                    post.put("direction", order.ordinal());
                    if (bucket != null) {
                        post.put("bucket", (Object)bucket);
                    }
                    if (afterId != null) {
                        post.put("begin_after_id", (Object)afterId);
                    }
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                    return;
                }
                Branch.this.requestQueue_.enqueue(new ServerRequest("t_get_reward_history", post));
                Branch.this.processNextQueueItem();
            }
        }).start();
    }

    public void userCompletedAction(final String action, final JSONObject metadata) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Branch.this.retryCount_ = 0;
                JSONObject post = new JSONObject();
                try {
                    post.put("app_id", (Object)Branch.this.prefHelper_.getAppKey());
                    post.put("session_id", (Object)Branch.this.prefHelper_.getSessionID());
                    post.put("event", (Object)action);
                    if (metadata != null) {
                        post.put("metadata", (Object)metadata);
                    }
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                    return;
                }
                Branch.this.requestQueue_.enqueue(new ServerRequest("t_complete_action", post));
                Branch.this.processNextQueueItem();
            }
        }).start();
    }

    public void userCompletedAction(String action) {
        this.userCompletedAction(action, null);
    }

    @Deprecated
    public JSONObject getInstallReferringParams() {
        return this.getFirstReferringParams();
    }

    public JSONObject getFirstReferringParams() {
        String storedParam = this.prefHelper_.getInstallParams();
        return this.convertParamsStringToDictionary(storedParam);
    }

    @Deprecated
    public JSONObject getReferringParams() {
        return this.getLatestReferringParams();
    }

    public JSONObject getLatestReferringParams() {
        String storedParam = this.prefHelper_.getSessionParams();
        return this.convertParamsStringToDictionary(storedParam);
    }

    public void getShortUrl(BranchLinkCreateListener callback) {
        this.generateShortLink(null, LINK_TYPE_UNLIMITED_USE, null, null, null, null, this.stringifyParams(null), callback);
    }

    public void getShortUrl(JSONObject params, BranchLinkCreateListener callback) {
        this.generateShortLink(null, LINK_TYPE_UNLIMITED_USE, null, null, null, null, this.stringifyParams(params), callback);
    }

    public void getReferralUrl(String channel, JSONObject params, BranchLinkCreateListener callback) {
        this.generateShortLink(null, LINK_TYPE_UNLIMITED_USE, null, channel, FEATURE_TAG_REFERRAL, null, this.stringifyParams(params), callback);
    }

    public void getReferralUrl(Collection<String> tags, String channel, JSONObject params, BranchLinkCreateListener callback) {
        this.generateShortLink(null, LINK_TYPE_UNLIMITED_USE, tags, channel, FEATURE_TAG_REFERRAL, null, this.stringifyParams(params), callback);
    }

    public void getContentUrl(String channel, JSONObject params, BranchLinkCreateListener callback) {
        this.generateShortLink(null, LINK_TYPE_UNLIMITED_USE, null, channel, FEATURE_TAG_SHARE, null, this.stringifyParams(params), callback);
    }

    public void getContentUrl(Collection<String> tags, String channel, JSONObject params, BranchLinkCreateListener callback) {
        this.generateShortLink(null, LINK_TYPE_UNLIMITED_USE, tags, channel, FEATURE_TAG_SHARE, null, this.stringifyParams(params), callback);
    }

    public void getShortUrl(String channel, String feature, String stage, JSONObject params, BranchLinkCreateListener callback) {
        this.generateShortLink(null, LINK_TYPE_UNLIMITED_USE, null, channel, feature, stage, this.stringifyParams(params), callback);
    }

    public void getShortUrl(String alias, String channel, String feature, String stage, JSONObject params, BranchLinkCreateListener callback) {
        this.generateShortLink(alias, LINK_TYPE_UNLIMITED_USE, null, channel, feature, stage, this.stringifyParams(params), callback);
    }

    public void getShortUrl(int type, String channel, String feature, String stage, JSONObject params, BranchLinkCreateListener callback) {
        this.generateShortLink(null, type, null, channel, feature, stage, this.stringifyParams(params), callback);
    }

    public void getShortUrl(Collection<String> tags, String channel, String feature, String stage, JSONObject params, BranchLinkCreateListener callback) {
        this.generateShortLink(null, LINK_TYPE_UNLIMITED_USE, tags, channel, feature, stage, this.stringifyParams(params), callback);
    }

    public void getShortUrl(String alias, Collection<String> tags, String channel, String feature, String stage, JSONObject params, BranchLinkCreateListener callback) {
        this.generateShortLink(alias, LINK_TYPE_UNLIMITED_USE, tags, channel, feature, stage, this.stringifyParams(params), callback);
    }

    public void getShortUrl(int type, Collection<String> tags, String channel, String feature, String stage, JSONObject params, BranchLinkCreateListener callback) {
        this.generateShortLink(null, type, tags, channel, feature, stage, this.stringifyParams(params), callback);
    }

    public void getReferralCode(BranchReferralInitListener callback) {
        this.getReferralCodeCallback_ = callback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                JSONObject post = new JSONObject();
                try {
                    post.put("app_id", (Object)Branch.this.prefHelper_.getAppKey());
                    post.put("identity_id", (Object)Branch.this.prefHelper_.getIdentityID());
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                    return;
                }
                Branch.this.requestQueue_.enqueue(new ServerRequest("t_get_referral_code", post));
                Branch.this.processNextQueueItem();
            }
        }).start();
    }

    public void getReferralCode(int amount, BranchReferralInitListener callback) {
        this.getReferralCode(null, amount, null, REEFERRAL_BUCKET_DEFAULT, REFERRAL_CODE_AWARD_UNLIMITED, REFERRAL_CODE_LOCATION_REFERRING_USER, callback);
    }

    public void getReferralCode(String prefix, int amount, BranchReferralInitListener callback) {
        this.getReferralCode(prefix, amount, null, REEFERRAL_BUCKET_DEFAULT, REFERRAL_CODE_AWARD_UNLIMITED, REFERRAL_CODE_LOCATION_REFERRING_USER, callback);
    }

    public void getReferralCode(int amount, Date expiration, BranchReferralInitListener callback) {
        this.getReferralCode(null, amount, expiration, REEFERRAL_BUCKET_DEFAULT, REFERRAL_CODE_AWARD_UNLIMITED, REFERRAL_CODE_LOCATION_REFERRING_USER, callback);
    }

    public void getReferralCode(String prefix, int amount, Date expiration, BranchReferralInitListener callback) {
        this.getReferralCode(prefix, amount, expiration, REEFERRAL_BUCKET_DEFAULT, REFERRAL_CODE_AWARD_UNLIMITED, REFERRAL_CODE_LOCATION_REFERRING_USER, callback);
    }

    public void getReferralCode(String prefix, int amount, int calculationType, int location, BranchReferralInitListener callback) {
        this.getReferralCode(prefix, amount, null, REEFERRAL_BUCKET_DEFAULT, calculationType, location, callback);
    }

    public void getReferralCode(final String prefix, final int amount, final Date expiration, final String bucket, final int calculationType, final int location, BranchReferralInitListener callback) {
        this.getReferralCodeCallback_ = callback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                JSONObject post = new JSONObject();
                try {
                    post.put("app_id", (Object)Branch.this.prefHelper_.getAppKey());
                    post.put("identity_id", (Object)Branch.this.prefHelper_.getIdentityID());
                    post.put("calculation_type", calculationType);
                    post.put("location", location);
                    post.put("type", (Object)REFERRAL_CODE_TYPE);
                    post.put("creation_source", REFERRAL_CREATION_SOURCE_SDK);
                    post.put("amount", amount);
                    post.put("bucket", (Object)(bucket != null ? bucket : REEFERRAL_BUCKET_DEFAULT));
                    if (prefix != null && prefix.length() > 0) {
                        post.put("prefix", (Object)prefix);
                    }
                    if (expiration != null) {
                        post.put("expiration", (Object)Branch.this.convertDate(expiration));
                    }
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                    return;
                }
                Branch.this.requestQueue_.enqueue(new ServerRequest("t_get_referral_code", post));
                Branch.this.processNextQueueItem();
            }
        }).start();
    }

    public void validateReferralCode(final String code, BranchReferralInitListener callback) {
        this.validateReferralCodeCallback_ = callback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                JSONObject post = new JSONObject();
                try {
                    post.put("app_id", (Object)Branch.this.prefHelper_.getAppKey());
                    post.put("identity_id", (Object)Branch.this.prefHelper_.getIdentityID());
                    post.put("referral_code", (Object)code);
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                    return;
                }
                Branch.this.requestQueue_.enqueue(new ServerRequest("t_validate_referral_code", post));
                Branch.this.processNextQueueItem();
            }
        }).start();
    }

    public void applyReferralCode(final String code, BranchReferralInitListener callback) {
        this.applyReferralCodeCallback_ = callback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                JSONObject post = new JSONObject();
                try {
                    post.put("app_id", (Object)Branch.this.prefHelper_.getAppKey());
                    post.put("identity_id", (Object)Branch.this.prefHelper_.getIdentityID());
                    post.put("session_id", (Object)Branch.this.prefHelper_.getSessionID());
                    post.put("referral_code", (Object)code);
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                    return;
                }
                Branch.this.requestQueue_.enqueue(new ServerRequest("t_apply_referral_code", post));
                Branch.this.processNextQueueItem();
            }
        }).start();
    }

    private String convertDate(Date date) {
        return DateFormat.format((CharSequence)"yyyy-MM-dd", (Date)date).toString();
    }

    private String stringifyParams(JSONObject params) {
        if (params == null) {
            params = new JSONObject();
        }
        try {
            params.put("source", (Object)"android");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return params.toString();
    }

    private void generateShortLink(final String alias, final int type, final Collection<String> tags, final String channel, final String feature, final String stage, final String params, BranchLinkCreateListener callback) {
        this.linkCreateCallback_ = callback;
        if (this.hasUser()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JSONObject linkPost = new JSONObject();
                    try {
                        linkPost.put("app_id", (Object)Branch.this.prefHelper_.getAppKey());
                        linkPost.put("identity_id", (Object)Branch.this.prefHelper_.getIdentityID());
                        if (type != 0) {
                            linkPost.put("type", type);
                        }
                        if (tags != null) {
                            JSONArray tagArray = new JSONArray();
                            for (String tag : tags) {
                                tagArray.put((Object)tag);
                            }
                            linkPost.put("tags", (Object)tagArray);
                        }
                        if (alias != null) {
                            linkPost.put("alias", (Object)alias);
                        }
                        if (channel != null) {
                            linkPost.put("channel", (Object)channel);
                        }
                        if (feature != null) {
                            linkPost.put("feature", (Object)feature);
                        }
                        if (stage != null) {
                            linkPost.put("stage", (Object)stage);
                        }
                        if (params != null) {
                            linkPost.put("data", (Object)params);
                        }
                    }
                    catch (JSONException ex) {
                        ex.printStackTrace();
                    }
                    Branch.this.requestQueue_.enqueue(new ServerRequest("t_get_custom_url", linkPost));
                    Branch.this.processNextQueueItem();
                }
            }).start();
        }
    }

    private JSONObject convertParamsStringToDictionary(String paramString) {
        if (paramString.equals("bnc_no_value")) {
            return new JSONObject();
        }
        try {
            return new JSONObject(paramString);
        }
        catch (JSONException e) {
            byte[] encodedArray = Base64.decode(paramString.getBytes(), 2);
            try {
                return new JSONObject(new String(encodedArray));
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                return new JSONObject();
            }
        }
    }

    private void processNextQueueItem() {
        try {
            this.serverSema_.acquire();
            if (this.networkCount_ == 0 && this.requestQueue_.getSize() > 0) {
                this.networkCount_ = 1;
                ServerRequest req = this.requestQueue_.peek();
                if (!req.getTag().equals("t_register_close")) {
                    this.keepAlive();
                }
                if (req.getTag().equals("t_register_install")) {
                    this.kRemoteInterface_.registerInstall("bnc_no_value", this.debug_);
                } else if (req.getTag().equals("t_register_open")) {
                    this.kRemoteInterface_.registerOpen(this.debug_);
                } else if (req.getTag().equals("t_get_referral_counts") && this.hasUser() && this.hasSession()) {
                    this.kRemoteInterface_.getReferralCounts();
                } else if (req.getTag().equals("t_get_rewards") && this.hasUser() && this.hasSession()) {
                    this.kRemoteInterface_.getRewards();
                } else if (req.getTag().equals("t_redeem_rewards") && this.hasUser() && this.hasSession()) {
                    this.kRemoteInterface_.redeemRewards(req.getPost());
                } else if (req.getTag().equals("t_get_reward_history") && this.hasUser() && this.hasSession()) {
                    this.kRemoteInterface_.getCreditHistory(req.getPost());
                } else if (req.getTag().equals("t_complete_action") && this.hasUser() && this.hasSession()) {
                    this.kRemoteInterface_.userCompletedAction(req.getPost());
                } else if (req.getTag().equals("t_get_custom_url") && this.hasUser() && this.hasSession()) {
                    this.kRemoteInterface_.createCustomUrl(req.getPost());
                } else if (req.getTag().equals("t_identify_user") && this.hasUser() && this.hasSession()) {
                    this.kRemoteInterface_.identifyUser(req.getPost());
                } else if (req.getTag().equals("t_register_close") && this.hasUser() && this.hasSession()) {
                    this.kRemoteInterface_.registerClose();
                } else if (req.getTag().equals("t_logout") && this.hasUser() && this.hasSession()) {
                    this.kRemoteInterface_.logoutUser(req.getPost());
                } else if (req.getTag().equals("t_get_referral_code") && this.hasUser() && this.hasSession()) {
                    this.kRemoteInterface_.getReferralCode(req.getPost());
                } else if (req.getTag().equals("t_validate_referral_code") && this.hasUser() && this.hasSession()) {
                    this.kRemoteInterface_.validateReferralCode(req.getPost());
                } else if (req.getTag().equals("t_apply_referral_code") && this.hasUser() && this.hasSession()) {
                    this.kRemoteInterface_.applyReferralCode(req.getPost());
                } else if (!this.hasUser()) {
                    if (!this.hasAppKey() && this.hasSession()) {
                        Log.i((String)"BranchSDK", (String)"Branch Warning: User session has not been initialized");
                    } else {
                        this.networkCount_ = 0;
                        this.initSession();
                    }
                }
            } else {
                this.serverSema_.release();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleFailure() {
        final ServerRequest req = this.requestQueue_.peek();
        Handler mainHandler = new Handler(this.context_.getMainLooper());
        mainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (req.getTag().equals("t_register_install") || req.getTag().equals("t_register_open")) {
                    if (Branch.this.initSessionFinishedCallback_ != null) {
                        JSONObject obj = new JSONObject();
                        try {
                            obj.put("error_message", (Object)"Trouble reaching server. Please try again in a few minutes");
                        }
                        catch (JSONException ex) {
                            ex.printStackTrace();
                        }
                        Branch.this.initSessionFinishedCallback_.onInitFinished(obj);
                    }
                } else if (req.getTag().equals("t_get_referral_counts") || req.getTag().equals("t_get_rewards")) {
                    if (Branch.this.stateChangedCallback_ != null) {
                        Branch.this.stateChangedCallback_.onStateChanged(false);
                    }
                } else if (req.getTag().equals("t_get_reward_history")) {
                    if (Branch.this.creditHistoryCallback_ != null) {
                        Branch.this.creditHistoryCallback_.onReceivingResponse(null);
                    }
                } else if (req.getTag().equals("t_get_custom_url")) {
                    if (Branch.this.linkCreateCallback_ != null) {
                        Branch.this.linkCreateCallback_.onLinkCreate(null);
                    }
                } else if (req.getTag().equals("t_identify_user")) {
                    if (Branch.this.initIdentityFinishedCallback_ != null) {
                        JSONObject obj = new JSONObject();
                        try {
                            obj.put("error_message", (Object)"Trouble reaching server. Please try again in a few minutes");
                        }
                        catch (JSONException ex) {
                            ex.printStackTrace();
                        }
                        Branch.this.initIdentityFinishedCallback_.onInitFinished(obj);
                    }
                } else if (req.getTag().equals("t_get_referral_code")) {
                    if (Branch.this.getReferralCodeCallback_ != null) {
                        Branch.this.getReferralCodeCallback_.onInitFinished(null);
                    }
                } else if (req.getTag().equals("t_validate_referral_code")) {
                    if (Branch.this.validateReferralCodeCallback_ != null) {
                        Branch.this.validateReferralCodeCallback_.onInitFinished(null);
                    }
                } else if (req.getTag().equals("t_apply_referral_code") && Branch.this.applyReferralCodeCallback_ != null) {
                    Branch.this.applyReferralCodeCallback_.onInitFinished(null);
                }
            }
        });
    }

    private void retryLastRequest() {
        ++this.retryCount_;
        if (this.retryCount_ > 5) {
            this.handleFailure();
            this.requestQueue_.dequeue();
            this.retryCount_ = 0;
        } else {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateAllRequestsInQueue() {
        try {
            int i = 0;
            while (i < this.requestQueue_.getSize()) {
                ServerRequest req = this.requestQueue_.peekAt(i);
                if (req.getPost() != null) {
                    Iterator keys = req.getPost().keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if (key.equals("app_id")) {
                            req.getPost().put(key, (Object)this.prefHelper_.getAppKey());
                            continue;
                        }
                        if (key.equals("session_id")) {
                            req.getPost().put(key, (Object)this.prefHelper_.getSessionID());
                            continue;
                        }
                        if (!key.equals("identity_id")) continue;
                        req.getPost().put(key, (Object)this.prefHelper_.getIdentityID());
                    }
                }
                ++i;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void clearTimer() {
        if (this.closeTimer == null) {
            return;
        }
        this.closeTimer.cancel();
        this.closeTimer.purge();
        this.closeTimer = new Timer();
    }

    private void keepAlive() {
        this.keepAlive_ = true;
        this.clearTimer();
        this.closeTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Branch.this.keepAlive_ = false;
                    }
                }).start();
            }
        }, 5000L);
    }

    private boolean hasAppKey() {
        return !this.prefHelper_.getAppKey().equals("bnc_no_value");
    }

    private boolean hasSession() {
        return !this.prefHelper_.getSessionID().equals("bnc_no_value");
    }

    private boolean hasUser() {
        return !this.prefHelper_.getIdentityID().equals("bnc_no_value");
    }

    private void insertRequestAtFront(ServerRequest req) {
        if (this.networkCount_ == 0) {
            this.requestQueue_.insert(req, 0);
        } else {
            this.requestQueue_.insert(req, 1);
        }
    }

    private void registerInstallOrOpen(String tag) {
        if (!this.requestQueue_.containsInstallOrOpen()) {
            this.insertRequestAtFront(new ServerRequest(tag));
        } else {
            this.requestQueue_.moveInstallOrOpenToFront(tag, this.networkCount_);
        }
        this.processNextQueueItem();
    }

    private void initializeSession() {
        if (this.hasUser()) {
            this.registerInstallOrOpen("t_register_open");
        } else {
            this.registerInstallOrOpen("t_register_install");
        }
    }

    private void processReferralCounts(ServerResponse resp) {
        boolean updateListener = false;
        Iterator keys = resp.getObject().keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                JSONObject counts = resp.getObject().getJSONObject(key);
                int total = counts.getInt("total");
                int unique = counts.getInt("unique");
                if (total != this.prefHelper_.getActionTotalCount(key) || unique != this.prefHelper_.getActionUniqueCount(key)) {
                    updateListener = true;
                }
                this.prefHelper_.setActionTotalCount(key, total);
                this.prefHelper_.setActionUniqueCount(key, unique);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        final boolean finUpdateListener = updateListener;
        Handler mainHandler = new Handler(this.context_.getMainLooper());
        mainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Branch.this.stateChangedCallback_ != null) {
                    Branch.this.stateChangedCallback_.onStateChanged(finUpdateListener);
                }
            }
        });
    }

    private void processRewardCounts(ServerResponse resp) {
        boolean updateListener = false;
        Iterator keys = resp.getObject().keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                int credits = resp.getObject().getInt(key);
                if (credits != this.prefHelper_.getCreditCount(key)) {
                    updateListener = true;
                }
                this.prefHelper_.setCreditCount(key, credits);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        final boolean finUpdateListener = updateListener;
        Handler mainHandler = new Handler(this.context_.getMainLooper());
        mainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Branch.this.stateChangedCallback_ != null) {
                    Branch.this.stateChangedCallback_.onStateChanged(finUpdateListener);
                }
            }
        });
    }

    private void processCreditHistory(final ServerResponse resp) {
        Handler mainHandler = new Handler(this.context_.getMainLooper());
        mainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Branch.this.creditHistoryCallback_ != null) {
                    Branch.this.creditHistoryCallback_.onReceivingResponse(resp.getArray());
                }
            }
        });
    }

    private void processReferralCodeGet(final ServerResponse resp) {
        Handler mainHandler = new Handler(this.context_.getMainLooper());
        mainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Branch.this.getReferralCodeCallback_ != null) {
                    try {
                        JSONObject json;
                        if (!resp.getObject().has(REFERRAL_CODE)) {
                            json = new JSONObject();
                            json.put("error_message", (Object)"Failed to get referral code");
                        } else {
                            json = resp.getObject();
                        }
                        Branch.this.getReferralCodeCallback_.onInitFinished(json);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void processReferralCodeValidation(final ServerResponse resp) {
        Handler mainHandler = new Handler(this.context_.getMainLooper());
        mainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Branch.this.validateReferralCodeCallback_ != null) {
                    try {
                        JSONObject json;
                        if (!resp.getObject().has(REFERRAL_CODE)) {
                            json = new JSONObject();
                            json.put("error_message", (Object)"Invalid referral code");
                        } else {
                            json = resp.getObject();
                        }
                        Branch.this.validateReferralCodeCallback_.onInitFinished(json);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void processReferralCodeApply(final ServerResponse resp) {
        Handler mainHandler = new Handler(this.context_.getMainLooper());
        mainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Branch.this.applyReferralCodeCallback_ != null) {
                    try {
                        JSONObject json;
                        if (!resp.getObject().has(REFERRAL_CODE)) {
                            json = new JSONObject();
                            json.put("error_message", (Object)"Invalid referral code");
                        } else {
                            json = resp.getObject();
                        }
                        Branch.this.applyReferralCodeCallback_.onInitFinished(json);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static interface BranchLinkCreateListener {
        public void onLinkCreate(String var1);
    }

    public static interface BranchListResponseListener {
        public void onReceivingResponse(JSONArray var1);
    }

    public static interface BranchReferralInitListener {
        public void onInitFinished(JSONObject var1);
    }

    public static interface BranchReferralStateChangedListener {
        public void onStateChanged(boolean var1);
    }

    public static enum CreditHistoryOrder {
        kMostRecentFirst,
        kLeastRecentFirst;

    }

    public class ReferralNetworkCallback
    implements NetworkCallback {
        @Override
        public void finished(ServerResponse serverResponse) {
            if (serverResponse != null) {
                try {
                    int status = serverResponse.getStatusCode();
                    String requestTag = serverResponse.getTag();
                    boolean needRecovery = !Branch.this.hasNetwork_;
                    Branch.this.hasNetwork_ = true;
                    if (status == 409) {
                        if (requestTag.equals("t_get_custom_url")) {
                            Handler mainHandler = new Handler(Branch.this.context_.getMainLooper());
                            mainHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    if (Branch.this.linkCreateCallback_ != null) {
                                        Branch.this.linkCreateCallback_.onLinkCreate(null);
                                    }
                                }
                            });
                        } else {
                            Log.i((String)"BranchSDK", (String)"Branch API Error: Conflicting resource error code from API");
                            Branch.this.handleFailure();
                        }
                        Branch.this.requestQueue_.dequeue();
                    } else if (status >= 400 && status < 500) {
                        if (serverResponse.getObject().has("error") && serverResponse.getObject().getJSONObject("error").has("message")) {
                            Log.i((String)"BranchSDK", (String)("Branch API Error: " + serverResponse.getObject().getJSONObject("error").getString("message")));
                        }
                        Branch.this.requestQueue_.dequeue();
                    } else if (status != 200) {
                        if (status == -1009) {
                            Branch.this.hasNetwork_ = false;
                            needRecovery = false;
                            Branch.this.handleFailure();
                            if (requestTag.equals("t_register_close")) {
                                Branch.this.requestQueue_.dequeue();
                            }
                            Log.i((String)"BranchSDK", (String)"Branch API Error: poor network connectivity. Please try again later.");
                        } else {
                            Branch.this.retryLastRequest();
                        }
                    } else if (requestTag.equals("t_get_referral_counts")) {
                        Branch.this.processReferralCounts(serverResponse);
                        Branch.this.requestQueue_.dequeue();
                    } else if (requestTag.equals("t_get_rewards")) {
                        Branch.this.processRewardCounts(serverResponse);
                        Branch.this.requestQueue_.dequeue();
                    } else if (requestTag.equals("t_get_reward_history")) {
                        Branch.this.processCreditHistory(serverResponse);
                        Branch.this.requestQueue_.dequeue();
                    } else if (requestTag.equals("t_register_install")) {
                        String params;
                        Branch.this.prefHelper_.setDeviceFingerPrintID(serverResponse.getObject().getString("device_fingerprint_id"));
                        Branch.this.prefHelper_.setIdentityID(serverResponse.getObject().getString("identity_id"));
                        Branch.this.prefHelper_.setUserURL(serverResponse.getObject().getString("link"));
                        Branch.this.prefHelper_.setSessionID(serverResponse.getObject().getString("session_id"));
                        Branch.this.prefHelper_.setLinkClickIdentifier("bnc_no_value");
                        if (Branch.this.prefHelper_.getIsReferrable() == 1) {
                            if (serverResponse.getObject().has("data")) {
                                params = serverResponse.getObject().getString("data");
                                Branch.this.prefHelper_.setInstallParams(params);
                            } else {
                                Branch.this.prefHelper_.setInstallParams("bnc_no_value");
                            }
                        }
                        if (serverResponse.getObject().has("link_click_id")) {
                            Branch.this.prefHelper_.setLinkClickID(serverResponse.getObject().getString("link_click_id"));
                        } else {
                            Branch.this.prefHelper_.setLinkClickID("bnc_no_value");
                        }
                        if (serverResponse.getObject().has("data")) {
                            params = serverResponse.getObject().getString("data");
                            Branch.this.prefHelper_.setSessionParams(params);
                        } else {
                            Branch.this.prefHelper_.setSessionParams("bnc_no_value");
                        }
                        Branch.this.updateAllRequestsInQueue();
                        Handler mainHandler = new Handler(Branch.this.context_.getMainLooper());
                        mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (Branch.this.initSessionFinishedCallback_ != null) {
                                    Branch.this.initSessionFinishedCallback_.onInitFinished(Branch.this.getLatestReferringParams());
                                }
                            }
                        });
                        Branch.this.requestQueue_.dequeue();
                    } else if (requestTag.equals("t_register_open")) {
                        String params;
                        Branch.this.prefHelper_.setSessionID(serverResponse.getObject().getString("session_id"));
                        Branch.this.prefHelper_.setLinkClickIdentifier("bnc_no_value");
                        if (serverResponse.getObject().has("identity_id")) {
                            Branch.this.prefHelper_.setIdentityID(serverResponse.getObject().getString("identity_id"));
                        }
                        if (serverResponse.getObject().has("link_click_id")) {
                            Branch.this.prefHelper_.setLinkClickID(serverResponse.getObject().getString("link_click_id"));
                        } else {
                            Branch.this.prefHelper_.setLinkClickID("bnc_no_value");
                        }
                        if (Branch.this.prefHelper_.getIsReferrable() == 1 && serverResponse.getObject().has("data")) {
                            params = serverResponse.getObject().getString("data");
                            Branch.this.prefHelper_.setInstallParams(params);
                        }
                        if (serverResponse.getObject().has("data")) {
                            params = serverResponse.getObject().getString("data");
                            Branch.this.prefHelper_.setSessionParams(params);
                        } else {
                            Branch.this.prefHelper_.setSessionParams("bnc_no_value");
                        }
                        Handler mainHandler = new Handler(Branch.this.context_.getMainLooper());
                        mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (Branch.this.initSessionFinishedCallback_ != null) {
                                    Branch.this.initSessionFinishedCallback_.onInitFinished(Branch.this.getLatestReferringParams());
                                }
                            }
                        });
                        Branch.this.requestQueue_.dequeue();
                    } else if (requestTag.equals("t_get_custom_url")) {
                        final String url = serverResponse.getObject().getString("url");
                        Handler mainHandler = new Handler(Branch.this.context_.getMainLooper());
                        mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (Branch.this.linkCreateCallback_ != null) {
                                    Branch.this.linkCreateCallback_.onLinkCreate(url);
                                }
                            }
                        });
                        Branch.this.requestQueue_.dequeue();
                    } else if (requestTag.equals("t_logout")) {
                        Branch.this.prefHelper_.setSessionID(serverResponse.getObject().getString("session_id"));
                        Branch.this.prefHelper_.setIdentityID(serverResponse.getObject().getString("identity_id"));
                        Branch.this.prefHelper_.setUserURL(serverResponse.getObject().getString("link"));
                        Branch.this.prefHelper_.setInstallParams("bnc_no_value");
                        Branch.this.prefHelper_.setSessionParams("bnc_no_value");
                        Branch.this.prefHelper_.setIdentity("bnc_no_value");
                        Branch.this.prefHelper_.clearUserValues();
                        Branch.this.requestQueue_.dequeue();
                    } else if (requestTag.equals("t_identify_user")) {
                        ServerRequest req;
                        Branch.this.prefHelper_.setIdentityID(serverResponse.getObject().getString("identity_id"));
                        Branch.this.prefHelper_.setUserURL(serverResponse.getObject().getString("link"));
                        if (serverResponse.getObject().has("referring_data")) {
                            String params = serverResponse.getObject().getString("referring_data");
                            Branch.this.prefHelper_.setInstallParams(params);
                        }
                        if (Branch.this.requestQueue_.getSize() > 0 && (req = Branch.this.requestQueue_.peek()).getPost() != null && req.getPost().has("identity")) {
                            Branch.this.prefHelper_.setIdentity(req.getPost().getString("identity"));
                        }
                        Handler mainHandler = new Handler(Branch.this.context_.getMainLooper());
                        mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (Branch.this.initIdentityFinishedCallback_ != null) {
                                    Branch.this.initIdentityFinishedCallback_.onInitFinished(Branch.this.getFirstReferringParams());
                                }
                            }
                        });
                        Branch.this.requestQueue_.dequeue();
                    } else if (requestTag.equals("t_get_referral_code")) {
                        Branch.this.processReferralCodeGet(serverResponse);
                        Branch.this.requestQueue_.dequeue();
                    } else if (requestTag.equals("t_validate_referral_code")) {
                        Branch.this.processReferralCodeValidation(serverResponse);
                        Branch.this.requestQueue_.dequeue();
                    } else if (requestTag.equals("t_apply_referral_code")) {
                        Branch.this.processReferralCodeApply(serverResponse);
                        Branch.this.requestQueue_.dequeue();
                    } else {
                        Branch.this.requestQueue_.dequeue();
                    }
                    if (needRecovery) {
                        Branch.this.recoverFromQueue();
                    }
                    Branch.this.networkCount_ = 0;
                    Branch.this.serverSema_.release();
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

