/*
 * Decompiled with CFR 0.152.
 */
package io.bpic.aws.sqs.ra.inbound;

import io.bpic.aws.sqs.ra.inbound.SQSJMSActivation;
import io.bpic.aws.sqs.ra.inbound.SQSJMSActivationSpec;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

public class SQSJMSResourceAdapter
implements ResourceAdapter {
    private static final Logger logger = Logger.getLogger("io.bpic.aws.sqs.ra");
    private final Map<ActivationSpec, SQSJMSActivation> activations = new ConcurrentHashMap<ActivationSpec, SQSJMSActivation>();
    private SQSJMSActivationSpec sqsSpec;

    public void start(BootstrapContext ctx) {
        logger.info("Amazon SQS Resource Adapter Started...");
    }

    public void stop() {
        logger.info("Amazon SQS Resource Adapter Stopped!");
        for (SQSJMSActivation value : this.activations.values()) {
            try {
                value.close();
            }
            catch (JMSException e) {
                logger.log(Level.SEVERE, "Failed to close connection", e);
            }
        }
        this.activations.clear();
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        this.sqsSpec = (SQSJMSActivationSpec)spec;
        SQSJMSActivation activation = new SQSJMSActivation(endpointFactory, this.sqsSpec);
        this.activations.put(spec, activation);
        activation.start();
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        SQSJMSActivation activation = this.activations.remove(spec);
        if (activation != null) {
            try {
                activation.close();
            }
            catch (JMSException e) {
                logger.log(Level.SEVERE, "Failed to close connection", e);
            }
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        throw new NotSupportedException("Not supported!");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQSJMSResourceAdapter that = (SQSJMSResourceAdapter)o;
        return this.activations.equals(that.activations) && this.sqsSpec.equals(that.sqsSpec);
    }

    public int hashCode() {
        return Objects.hash(this.activations, this.sqsSpec);
    }
}

