/*
 * Decompiled with CFR 0.152.
 */
package io.bpic.aws.sqs.ra.inbound;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.regions.AwsRegionProviderChain;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.regions.Regions;
import com.amazonaws.util.StringUtils;
import io.bpic.aws.sqs.ra.inbound.SQSJMSActivation;
import io.bpic.aws.sqs.ra.inbound.SQSJMSResourceAdapter;
import java.io.Serializable;
import javax.jms.Queue;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;

public class SQSJMSActivationSpec
implements ActivationSpec,
Serializable,
AWSCredentialsProvider {
    private ResourceAdapter adapter;
    private String awsAccessKeyId;
    private String awsSecretKey;
    private String region;
    private String destination;
    private String destinationType;
    private String acknowledgeMode;
    private final AWSCredentials awsCredentials = new AWSCredentials(){

        public String getAWSAccessKeyId() {
            if (StringUtils.isNullOrEmpty((String)SQSJMSActivationSpec.this.awsAccessKeyId)) {
                throw new SdkClientException("awsAccessKeyId not set on " + this.getClass().getName());
            }
            return SQSJMSActivationSpec.this.awsAccessKeyId;
        }

        public String getAWSSecretKey() {
            if (StringUtils.isNullOrEmpty((String)SQSJMSActivationSpec.this.awsSecretKey)) {
                throw new SdkClientException("awsSecretKey not set on " + this.getClass().getName());
            }
            return SQSJMSActivationSpec.this.awsSecretKey;
        }
    };
    private final AWSCredentialsProvider awsCredentialsProvider = new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new AWSStaticCredentialsProvider(this.awsCredentials), DefaultAWSCredentialsProviderChain.getInstance()});

    public ResourceAdapter getResourceAdapter() {
        return this.adapter;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        if (this.adapter != null) {
            throw new ResourceException("ResourceAdapter already set");
        }
        if (!(ra instanceof SQSJMSResourceAdapter)) {
            throw new ResourceException("ResourceAdapter is not of type: " + SQSJMSResourceAdapter.class.getName());
        }
        this.adapter = ra;
    }

    public void validate() throws InvalidPropertyException {
        if (!Queue.class.getName().equals(this.destinationType)) {
            throw new InvalidPropertyException("'destinationType' must be '" + Queue.class.getName() + "'.");
        }
        try {
            SQSJMSActivation.acknowledgeModeStringToInt(this.acknowledgeMode);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidPropertyException(e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isNullOrEmpty((String)this.getAwsRegionProvider().getRegion())) {
            throw new InvalidPropertyException("Must set the 'region' property or provide the region to use via one of the com.amazonaws.regions.DefaultAwsRegionProviderChain supported mechanisms");
        }
        try {
            this.getCredentials();
        }
        catch (Exception e) {
            throw new InvalidPropertyException("Must set awsAccessKeyId and awsSecretKey or provide the credentials to use via one of the com.amazonaws.auth.DefaultAWSCredentialsProviderChain supported mechanisms", (Throwable)e);
        }
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public void setAwsAccessKeyId(String awsAccessKeyId) {
        this.awsAccessKeyId = awsAccessKeyId;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public AWSCredentials getCredentials() {
        return this.awsCredentialsProvider.getCredentials();
    }

    public String getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void refresh() {
        this.awsCredentialsProvider.refresh();
    }

    public AwsRegionProvider getAwsRegionProvider() {
        return new AwsRegionProviderChain(new AwsRegionProvider[]{new AwsRegionProvider(){

            public String getRegion() {
                return StringUtils.isNullOrEmpty((String)SQSJMSActivationSpec.this.region) ? Regions.getCurrentRegion().getName() : SQSJMSActivationSpec.this.region;
            }
        }, new DefaultAwsRegionProviderChain()});
    }
}

