/*
 * Decompiled with CFR 0.152.
 */
package io.bpic.aws.sqs.ra.inbound;

import com.amazon.sqs.javamessaging.ProviderConfiguration;
import com.amazon.sqs.javamessaging.SQSConnection;
import com.amazon.sqs.javamessaging.SQSConnectionFactory;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.QueueDoesNotExistException;
import io.bpic.aws.sqs.ra.inbound.SQSJMSActivationSpec;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;

public class SQSJMSActivation {
    private static final Logger logger = Logger.getLogger(SQSJMSActivation.class.getName());
    private MessageEndpointFactory endpointFactory;
    private SQSJMSActivationSpec spec;
    private SQSConnection connection;
    private static final Method ON_MESSAGE;

    public SQSJMSActivation(MessageEndpointFactory endpointFactory, SQSJMSActivationSpec spec) {
        this.endpointFactory = endpointFactory;
        this.spec = spec;
    }

    public void start() throws ResourceException {
        logger.info("Starting activation...");
        String region = this.spec.getAwsRegionProvider().getRegion();
        if (region == null) {
            throw new IllegalStateException("No region set. Please set a region or provide one using a method supported by com.amazonaws.regions.DefaultAwsRegionProviderChain");
        }
        Regions regions = Regions.fromName((String)region);
        SQSConnectionFactory connectionFactory = new SQSConnectionFactory(new ProviderConfiguration(), (AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withRegion(regions)).withCredentials((AWSCredentialsProvider)this.spec));
        Queue sqsJmsQueue = this.getSQSJMSQueue(this.spec);
        try {
            Queue queue;
            this.connection = connectionFactory.createConnection();
            QueueSession session = this.connection.createQueueSession(false, SQSJMSActivation.acknowledgeModeStringToInt(this.spec.getAcknowledgeMode()));
            try {
                queue = session.createQueue(sqsJmsQueue.getQueueName());
            }
            catch (QueueDoesNotExistException | InvalidDestinationException e) {
                throw new ResourceException("Queue with name '" + sqsJmsQueue.getQueueName() + "' does not exist", e);
            }
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            messageConsumer.setMessageListener(new MessageListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onMessage(Message message) {
                    MessageEndpoint messageEndpoint = null;
                    try {
                        messageEndpoint = SQSJMSActivation.this.endpointFactory.createEndpoint(null);
                        messageEndpoint.beforeDelivery(ON_MESSAGE);
                        if (message != null) {
                            ON_MESSAGE.invoke((Object)messageEndpoint, message);
                        }
                        messageEndpoint.afterDelivery();
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException | ResourceException e) {
                        logger.log(Level.SEVERE, null, e);
                    }
                    finally {
                        if (messageEndpoint != null) {
                            messageEndpoint.release();
                        }
                    }
                }
            });
            this.connection.start();
        }
        catch (JMSException | ResourceException e) {
            throw new ResourceException(e);
        }
    }

    static int acknowledgeModeStringToInt(String acknowledgeMode) {
        if ("auto-acknowledge".equalsIgnoreCase(acknowledgeMode)) {
            return 1;
        }
        if ("client-acknowledge".equalsIgnoreCase(acknowledgeMode)) {
            return 2;
        }
        if ("dups-ok-acknowledge".equalsIgnoreCase(acknowledgeMode)) {
            return 3;
        }
        throw new IllegalArgumentException("valid acknowledgeModes are: auto-acknowledge, client-acknowledge, and dups-ok-acknowledge");
    }

    public void close() throws JMSException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    private Queue getSQSJMSQueue(SQSJMSActivationSpec sqsSpec) throws ResourceException {
        try {
            InitialContext ctx = new InitialContext();
            return (Queue)ctx.lookup(sqsSpec.getDestination());
        }
        catch (NamingException e) {
            throw new ResourceException("JNDI lookup failed for " + sqsSpec.getDestination(), (Throwable)e);
        }
    }

    static {
        try {
            ON_MESSAGE = MessageListener.class.getMethod("onMessage", Message.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

