/*
 * Decompiled with CFR 0.152.
 */
package io.bitzl.hamcrest.extra.matcher;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.beans.HasPropertyWithValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasPropertyPath<T>
extends TypeSafeDiagnosingMatcher<T> {
    private String propertyPath;
    private Matcher<?> valueMatcher;

    private HasPropertyPath(String propertyPath, Matcher<?> valueMatcher) {
        this.propertyPath = propertyPath;
        this.valueMatcher = valueMatcher;
    }

    @Factory
    public static <T> Matcher<T> hasPropertyPath(String propertyPath) {
        return new HasPropertyPath<T>(propertyPath, Matchers.anything());
    }

    @Factory
    public static <T> Matcher<T> hasPropertyPath(String propertyPath, Matcher<?> valueMatcher) {
        return new HasPropertyPath<T>(propertyPath, valueMatcher);
    }

    protected boolean matchesSafely(T t, Description description) {
        String[] path = this.propertyPath.split("\\.");
        Matcher matcher = this.valueMatcher;
        for (int i = path.length - 1; i >= 0; --i) {
            String property = path[i];
            matcher = HasPropertyWithValue.hasProperty((String)property, matcher);
        }
        return ((HasPropertyWithValue)matcher).matchesSafely(t, description);
    }

    public void describeTo(Description description) {
        description.appendText("hasPropertyPath(").appendValue((Object)this.propertyPath).appendText(", ").appendDescriptionOf(this.valueMatcher).appendText(")");
    }
}

