/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.connectors.proto;

import io.bitsensor.lib.entity.proto.Datapoint;
import io.bitsensor.lib.entity.proto.DatapointReceiverGrpc;
import io.bitsensor.lib.entity.proto.Reply;
import io.bitsensor.plugins.java.core.connectors.AbstractApiCollector;
import io.bitsensor.plugins.java.core.logging.NoLog;
import io.bitsensor.proto.shaded.io.grpc.Channel;
import io.bitsensor.proto.shaded.io.grpc.ManagedChannel;
import io.bitsensor.proto.shaded.io.grpc.ManagedChannelBuilder;
import io.bitsensor.proto.shaded.io.grpc.Status;
import io.bitsensor.proto.shaded.io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@Named
@Singleton
@NoLog
public class ProtobufConnector
extends AbstractApiCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ProtobufConnector.class.getName());
    private ManagedChannel channel;
    private DatapointReceiverGrpc.DatapointReceiverStub stub;
    @Value(value="${bitsensor.apiconnector.protobuf.port:5011}")
    private int port;

    @PostConstruct
    public void setUri() {
        this.setEndpoint(ManagedChannelBuilder.forAddress((String)this.getHost(), (int)this.port).usePlaintext(true));
    }

    private void setEndpoint(ManagedChannelBuilder<?> channelBuilder) {
        this.channel = channelBuilder.build();
        this.stub = DatapointReceiverGrpc.newStub((Channel)this.channel);
    }

    public void shutdown() throws InterruptedException, IOException {
        super.shutdown();
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    private void log(Datapoint.Builder datapointBuilder) {
        this.stub.receiveDatapoint(datapointBuilder.build(), (StreamObserver)new StreamObserver<Reply>(){

            public void onNext(Reply value) {
            }

            public void onError(Throwable t) {
                LOGGER.warn("RPC failed {}", (Object)Status.fromThrowable((Throwable)t));
            }

            public void onCompleted() {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Sent datapoint.");
                }
            }
        });
    }

    public void send(Datapoint.Builder datapointBuilder) {
        if (datapointBuilder == null) {
            return;
        }
        try {
            this.log(datapointBuilder);
        }
        catch (Exception e) {
            LOGGER.error("Could not log DataPoint", (Throwable)e);
        }
    }
}

