package io.bitsensor.plugins.java.connectors.proto;

import io.bitsensor.lib.entity.proto.Datapoint.Builder;
import io.bitsensor.lib.entity.proto.DatapointReceiverGrpc;
import io.bitsensor.lib.entity.proto.Reply;
import io.bitsensor.plugins.java.core.connectors.AbstractApiCollector;
import io.bitsensor.plugins.java.core.logging.NoLog;
import io.bitsensor.proto.shaded.io.grpc.ManagedChannel;
import io.bitsensor.proto.shaded.io.grpc.ManagedChannelBuilder;
import io.bitsensor.proto.shaded.io.grpc.Status;
import io.bitsensor.proto.shaded.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

import javax.annotation.PostConstruct;
import javax.inject.Named;
import javax.inject.Singleton;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@Named
@Singleton
@NoLog
public class ProtobufConnector extends AbstractApiCollector {

    private static final Logger LOGGER = LoggerFactory.getLogger(ProtobufConnector.class.getName());
    private ManagedChannel channel;
    private DatapointReceiverGrpc.DatapointReceiverStub stub;

    @Value("${bitsensor.apiconnector.protobuf.port:5011}")
    private int port;

    @PostConstruct
    public void setUri() {
        setEndpoint(ManagedChannelBuilder
                .forAddress(getHost(), port)
                .usePlaintext(true));
    }

    private void setEndpoint(ManagedChannelBuilder<?> channelBuilder) {
        channel = channelBuilder.build();
        stub = DatapointReceiverGrpc.newStub(channel);
    }

    @Override
    public void shutdown() throws InterruptedException, IOException {
        super.shutdown();

        channel.shutdown().awaitTermination(5, TimeUnit.SECONDS);
    }

    private void log(Builder datapointBuilder) {
        stub.receiveDatapoint(datapointBuilder.build(), new StreamObserver<Reply>() {
            @Override
            public void onNext(Reply value) {
            }

            @Override
            public void onError(Throwable t) {
                LOGGER.warn("RPC failed {}", Status.fromThrowable(t));
            }

            @Override
            public void onCompleted() {
                if (LOGGER.isDebugEnabled())
                    LOGGER.debug("Sent datapoint.");
            }
        });
    }

    @Override
    public void send(Builder datapointBuilder) {
        if (datapointBuilder == null)
            return;

        try {
            log(datapointBuilder);
        } catch (Exception e) {
            LOGGER.error("Could not log DataPoint", e);
        }
    }
}
