/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.http.filter;

import io.bitsensor.proto.shaded.com.google.common.primitives.Bytes;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class BitSensorRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] requestBody = new byte[0];
    private boolean bufferFilled = false;

    public BitSensorRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public byte[] getRequestBody() throws IOException {
        int bytesRead;
        if (this.bufferFilled) {
            return Arrays.copyOf(this.requestBody, this.requestBody.length);
        }
        ServletInputStream inputStream = super.getInputStream();
        byte[] buffer = new byte[102400];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            this.requestBody = Bytes.concat((byte[][])new byte[][]{this.requestBody, Arrays.copyOfRange(buffer, 0, bytesRead)});
        }
        this.bufferFilled = true;
        return this.requestBody;
    }

    public ServletInputStream getInputStream() throws IOException {
        return new BitSensorServletInputStream(this.getRequestBody());
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    private static class BitSensorServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream buffer;

        public BitSensorServletInputStream(byte[] contents) {
            this.buffer = new ByteArrayInputStream(contents);
        }

        public int read() throws IOException {
            return this.buffer.read();
        }

        public boolean isFinished() {
            return this.buffer.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener listener) {
            throw new UnsupportedOperationException("Method not implemented.");
        }
    }
}

