/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.http.filter.handler;

import io.bitsensor.lib.entity.proto.Error;
import io.bitsensor.lib.entity.proto.GeneratedBy;
import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.handler.Handler;
import io.bitsensor.plugins.java.http.filter.handler.RequestHandler;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;

@Component
public class CookieHandler
implements RequestHandler {
    public static final String SECURE_ATTRIBUTE_NAME = "Secure";
    public static final String HTTP_ONLY_ATTRIBUTE_NAME = "HttpOnly";

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) {
        if (request.getCookies() == null) {
            return;
        }
        for (Cookie cookie : request.getCookies()) {
            String cookieName = "cookie." + cookie.getName();
            BitSensor.addInput((String)cookieName, (String)cookie.getValue());
            ArrayList<String> cookieCompliance = new ArrayList<String>();
            if (!cookie.getSecure()) {
                cookieCompliance.add(SECURE_ATTRIBUTE_NAME);
            }
            if (!cookie.isHttpOnly()) {
                cookieCompliance.add(HTTP_ONLY_ATTRIBUTE_NAME);
            }
            if (cookieCompliance.isEmpty()) {
                return;
            }
            BitSensor.addError((Error)Error.newBuilder().setGeneratedBy(GeneratedBy.PLUGIN).setCode(1).setDescription("Non-Compliance for " + cookieName + ": " + String.join((CharSequence)", ", cookieCompliance) + " flag(s) not set.").setType("compliance").build());
        }
    }

    public Handler.ExecutionMoment getExecutionMoment() {
        return Handler.ExecutionMoment.PRE_HANDLE;
    }
}

