package io.bitsensor.plugins.java.spring;

import io.bitsensor.plugins.java.http.filter.BitSensorFilter;
import io.bitsensor.plugins.java.http.listener.BitSensorServletContextListener;
import io.bitsensor.plugins.java.http.listener.BitSensorServletRequestListener;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import javax.servlet.DispatcherType;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestListener;

@Configuration
@ComponentScan(basePackageClasses = BitSensorWebConfiguration.class)
public class BitSensorWebConfiguration {

    @Bean
    public BitSensorFilter bitSensorFilter() {
        return new BitSensorFilter();
    }

    @Bean
    public BitSensorServletContextListener bitSensorServletContextListener() {
        return new BitSensorServletContextListener();
    }

    @Bean
    public BitSensorServletRequestListener bitSensorServletRequestListener() {
        return new BitSensorServletRequestListener();
    }

    @Bean
    public ServletListenerRegistrationBean<ServletContextListener> servletContextListenerRegistrationBean(
            BitSensorServletContextListener bitSensorServletContextListener
    ) {
        ServletListenerRegistrationBean<ServletContextListener> bean =
                new ServletListenerRegistrationBean<>();
        bean.setListener(bitSensorServletContextListener);
        bean.setOrder(1);
        return bean;
    }

    @Bean
    public ServletListenerRegistrationBean<ServletRequestListener> servletRequestListenerRegistrationBean(
            BitSensorServletRequestListener bitSensorServletRequestListener
    ) {
        ServletListenerRegistrationBean<ServletRequestListener> bean =
                new ServletListenerRegistrationBean<>();
        bean.setListener(bitSensorServletRequestListener);
        bean.setOrder(1);
        return bean;
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean(BitSensorFilter bitSensorFilter) {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter(bitSensorFilter);
        bean.setName("BitSensorFilterChain");
        bean.addUrlPatterns("/*");
        bean.setDispatcherTypes(DispatcherType.REQUEST,
                DispatcherType.FORWARD,
                DispatcherType.INCLUDE,
                DispatcherType.ERROR);
        bean.setOrder(1);

        return bean;
    }
}
