package io.bitsensor.plugins.java.spring;

import io.bitsensor.lib.entity.proto.Error;
import io.bitsensor.lib.entity.proto.GeneratedBy;
import io.bitsensor.plugins.java.core.BitSensor;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Component
@Order(value = Ordered.HIGHEST_PRECEDENCE)
public class BitSensorExceptionResolver implements HandlerExceptionResolver {

    @Override
    public ModelAndView resolveException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler, Exception ex) {
        Error.Builder error = Error.newBuilder()
                .setGeneratedBy(GeneratedBy.PLUGIN)
                .setType(ex.getClass().getName())
                .setDescription(ex.getMessage());

        if (handler instanceof HandlerMethod)
            error = error.setLocation(((HandlerMethod) handler).getBeanType().getName());

        final Error finalError = error.build();
        BitSensor.apply(datapointBuilder -> BitSensor.addError(finalError));

        //returning null for default processing
        return null;
    }
}
