package io.bitsensor.plugins.java.http.filter.handler;

import io.bitsensor.plugins.java.core.handler.HandlerManager;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Contains the data collection handlers for HTTP requests.
 */
@Component
public class RequestHandlerManager extends HandlerManager<RequestHandler> implements HttpInvocationHandler {

    /**
     * {@inheritDoc}
     */
    @Override
    public void preHandle(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null)
            return;
        getHandlers()
                .stream()
                .filter(handler -> handler.getExecutionMoment() == RequestHandler.ExecutionMoment.PRE_HANDLE)
                .forEach(handler -> handler.handle(request, response));
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null)
            return;
        getHandlers()
                .stream()
                .filter(handler -> handler.getExecutionMoment() == RequestHandler.ExecutionMoment.POST_HANDLE)
                .forEach(handler -> handler.handle(request, response));
    }
}
