package io.bitsensor.plugins.java.http.filter.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * A handler interface that is implemented by the {@link RequestHandlerManager}.
 */
public interface HttpInvocationHandler {

    /**
     * Runs all handlers that should be executed before the request is handled by the application.
     *
     * @param request  The current HTTP request.
     * @param response The current HTTP response.
     */
    void preHandle(HttpServletRequest request, HttpServletResponse response);

    /**
     * Runs all handlers that should be executed after the request is handled by the application.
     *
     * @param request  The current HTTP request.
     * @param response The current HTTP response.
     */
    void postHandle(HttpServletRequest request, HttpServletResponse response);
}
