package io.bitsensor.plugins.java.spring;

import io.bitsensor.plugins.java.http.configuration.HttpMessageConverterReadInterceptor;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

@Component
public class HttpMessageConverterAdvisor extends AbstractPointcutAdvisor {

    private static final StaticMethodMatcherPointcut staticMethodMatcherPointcut =
            new StaticMethodMatcherPointcut() {
                @Override
                public boolean matches(Method method, Class<?> targetClass) {
                    return method.getName().startsWith("read") &&
                            HttpMessageConverter.class.isAssignableFrom(targetClass);
                }
            };

    private MethodInterceptor advice = new HttpMessageConverterReadInterceptor();

    @Override
    public Pointcut getPointcut() {
        return staticMethodMatcherPointcut;
    }

    @Override
    public Advice getAdvice() {
        return advice;
    }
}
