/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.http.filter.handler;

import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.handler.Handler;
import io.bitsensor.plugins.java.http.filter.BitSensorRequestWrapper;
import io.bitsensor.plugins.java.http.filter.handler.RequestHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;

@Component
public class HttpInputHandler
implements RequestHandler {
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) {
        String method = request.getMethod().toLowerCase();
        this.handleParameterMap(request, method);
        this.handleRequestBody(request, method);
        String sessionId = request.getRequestedSessionId();
        if (sessionId != null) {
            BitSensor.addContext((String)"session.sessionId", (String)sessionId);
        }
    }

    private void handleParameterMap(HttpServletRequest request, String method) {
        for (Map.Entry valuesByKey : request.getParameterMap().entrySet()) {
            Object[] values = (String[])valuesByKey.getValue();
            String key = (String)valuesByKey.getKey();
            Object valueString = "";
            if (values.length > 1) {
                valueString = Arrays.toString(values);
            } else if (values.length == 1) {
                valueString = values[0];
            }
            BitSensor.addInput((String)("http." + method + "." + key), (String)valueString);
        }
    }

    private void handleRequestBody(HttpServletRequest request, String method) {
        if (!(request instanceof BitSensorRequestWrapper)) {
            return;
        }
        String body = null;
        try {
            body = new String(((BitSensorRequestWrapper)request).getRequestBody());
            if (!body.trim().isEmpty()) {
                BitSensor.addInput((String)("http." + method + ".body"), (String)body);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Handler.ExecutionMoment getExecutionMoment() {
        return Handler.ExecutionMoment.PRE_HANDLE;
    }
}

