package io.bitsensor.plugins.java.http.filter;


import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.BitSensorDI;
import io.bitsensor.plugins.java.http.AccessDeniedException;
import io.bitsensor.plugins.java.http.filter.handler.RequestHandlerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * The {@code BitSensorFilter} intercepts each request and collects data about it. After the request is finished
 */
public class BitSensorFilter implements Filter {

    /**
     * The HandlerManager that contains the data collection handlers that can be run.
     */
    private final RequestHandlerManager requestHandlerManager;

    public BitSensorFilter() {
        this.requestHandlerManager = BitSensorDI.getBean(RequestHandlerManager.class);
    }

    /**
     * The logger.
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(BitSensorFilter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            LOGGER.info("Starting " + filterConfig.getFilterName());
        } catch (Exception e) {
            LOGGER.error("Exception during initialization", e);
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            try {
                BitSensor.apply(datapointBuilder -> {
                    requestHandlerManager.preHandle(
                            (HttpServletRequest) request,
                            (HttpServletResponse) response);
                });
            } catch (AccessDeniedException e) {
                throw e;
            } catch (Exception e) {
                LOGGER.error("BitSensor preHandle Filter Chain Exception", e);
            }
        }

        chain.doFilter(request, response);

        if (request instanceof HttpServletRequest) {
            try {
                BitSensor.apply(datapointBuilder -> {
                    requestHandlerManager.postHandle(
                            (HttpServletRequest) request,
                            (HttpServletResponse) response);
                });
            } catch (Exception e) {
                LOGGER.error("BitSensor postHandle Filter Chain Exception", e);
            }
        }
    }

    @Override
    public void destroy() {

    }
}
