/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.http.filter;

import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.BitSensorDI;
import io.bitsensor.plugins.java.http.AccessDeniedException;
import io.bitsensor.plugins.java.http.filter.handler.RequestHandlerManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitSensorFilter
implements Filter {
    private final RequestHandlerManager requestHandlerManager = (RequestHandlerManager)BitSensorDI.getBean(RequestHandlerManager.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(BitSensorFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            LOGGER.info("Starting " + filterConfig.getFilterName());
        }
        catch (Exception e) {
            LOGGER.error("Exception during initialization", (Throwable)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            try {
                BitSensor.apply(datapointBuilder -> this.requestHandlerManager.preHandle((HttpServletRequest)request, (HttpServletResponse)response));
            }
            catch (AccessDeniedException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("BitSensor preHandle Filter Chain Exception", (Throwable)e);
            }
        }
        chain.doFilter(request, response);
        if (request instanceof HttpServletRequest) {
            try {
                BitSensor.apply(datapointBuilder -> this.requestHandlerManager.postHandle((HttpServletRequest)request, (HttpServletResponse)response));
            }
            catch (Exception e) {
                LOGGER.error("BitSensor postHandle Filter Chain Exception", (Throwable)e);
            }
        }
    }

    public void destroy() {
    }
}

