package io.bitsensor.plugins.java.http.listener;

import io.bitsensor.plugins.java.core.BitSensor;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;

/**
 * A listener to initialize {@link BitSensor#datapointBuilder} and start collecting events and information of the
 * current request.
 */
public class BitSensorServletRequestListener implements ServletRequestListener {

    @Override
    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
        BitSensor.ship();
    }

    @Override
    public void requestInitialized(ServletRequestEvent servletEvent) {
        BitSensor.initialize();
        BitSensor.setHandlingRequest(true);
    }
}
