package io.bitsensor.plugins.java.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import io.bitsensor.lib.entity.proto.Error;
import io.bitsensor.lib.entity.proto.GeneratedBy;

public class ILoggingEventHelper {

    public static Error fromILoggingEvent(ILoggingEvent event) {
        Error.Builder error = Error.newBuilder()
                .setGeneratedBy(GeneratedBy.PLUGIN)
                .setCode(event.getLevel().toInt())
                .setType(event.getLevel().toString())
                .setLocation(event.getLoggerName());

        String message = event.getFormattedMessage();
        if (message != null)
            error.setDescription(message);

        StackTraceElement[] callerData = event.getCallerData();
        if (callerData != null && callerData.length > 0)
            error.setLine(event.getCallerData()[0].getLineNumber());

        return error.build();
    }
}
