/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.logging.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import io.bitsensor.lib.entity.proto.Error;
import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.logging.NoLog;
import io.bitsensor.plugins.java.logging.logback.ILoggingEventHelper;
import org.springframework.stereotype.Component;

@Component
public class LogbackAppender
extends AppenderBase<ILoggingEvent> {
    public LogbackAppender() {
        this.setName("BitSensor Logback Appender");
        this.addFilter(this.createNoLogFilter());
        ThresholdFilter thresholdFilter = new ThresholdFilter();
        thresholdFilter.setLevel(Level.INFO.levelStr);
        thresholdFilter.start();
        this.addFilter((Filter)thresholdFilter);
        this.start();
    }

    private Filter createNoLogFilter() {
        Filter<ILoggingEvent> filter = new Filter<ILoggingEvent>(){

            public FilterReply decide(ILoggingEvent event) {
                if (!this.isStarted()) {
                    return FilterReply.NEUTRAL;
                }
                try {
                    Class<?> cls = Class.forName(event.getLoggerName());
                    if (cls.isAnnotationPresent(NoLog.class)) {
                        return FilterReply.DENY;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return FilterReply.NEUTRAL;
            }
        };
        filter.start();
        return filter;
    }

    protected void append(ILoggingEvent event) {
        BitSensor.apply(datapointBuilder -> BitSensor.addError((Error)ILoggingEventHelper.fromILoggingEvent(event)));
    }
}

