package io.bitsensor.plugins.java.logging.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.logging.NoLog;
import org.springframework.stereotype.Component;

import static io.bitsensor.plugins.java.logging.logback.ILoggingEventHelper.fromILoggingEvent;

@Component
public class LogbackAppender extends AppenderBase<ILoggingEvent> {

    public LogbackAppender() {
        setName("BitSensor Logback Appender");

        addFilter(createNoLogFilter());

        ThresholdFilter thresholdFilter = new ThresholdFilter();
        thresholdFilter.setLevel(Level.INFO.levelStr);
        thresholdFilter.start();
        addFilter(thresholdFilter);

        start();
    }

    private Filter createNoLogFilter() {
        Filter filter = new Filter<ILoggingEvent>() {
            @Override
            public FilterReply decide(ILoggingEvent event) {
                if (!isStarted()) {
                    return FilterReply.NEUTRAL;
                }

                try {
                    Class<?> cls = Class.forName(event.getLoggerName());
                    if (cls.isAnnotationPresent(NoLog.class))
                        return FilterReply.DENY;

                } catch (ClassNotFoundException ignored) {
                }
                return FilterReply.NEUTRAL;
            }
        };
        filter.start();

        return filter;
    }

    @Override
    protected void append(ILoggingEvent event) {
        BitSensor.apply(datapointBuilder ->
                BitSensor.addError(fromILoggingEvent(event)));
    }
}
