/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.logging.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import io.bitsensor.lib.entity.proto.Error;
import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.logging.NoLog;
import io.bitsensor.plugins.java.logging.logback.ILoggingEventHelper;
import javax.inject.Named;

@Named
public class LogbackAppender
extends AppenderBase<ILoggingEvent> {
    public LogbackAppender() {
        this.setName("BitSensor Logback Appender");
        this.addFilter((Filter)new Filter<ILoggingEvent>(){

            public FilterReply decide(ILoggingEvent event) {
                try {
                    Class<?> cls = Class.forName(event.getLoggerName());
                    if (cls.isAnnotationPresent(NoLog.class)) {
                        return FilterReply.DENY;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return FilterReply.NEUTRAL;
            }
        });
        this.start();
    }

    protected void append(ILoggingEvent event) {
        BitSensor.apply(datapointBuilder -> BitSensor.addError((Error)ILoggingEventHelper.fromILoggingEvent(event)));
    }
}

