package io.bitsensor.plugins.java.logging.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.logging.NoLog;
import io.bitsensor.plugins.java.core.util.ComponentScanUtil;
import io.bitsensor.plugins.java.logging.ClassExclusionFilter;

import javax.inject.Named;

import static io.bitsensor.plugins.java.logging.logback.ILoggingEventHelper.fromILoggingEvent;


@Named
public class LogbackAppender extends AppenderBase<ILoggingEvent> {

    public LogbackAppender() {
        setName("BitSensor Logback Appender");

        addFilter(new ClassExclusionFilter(
                ComponentScanUtil.scanClassesWithAnnotation("io.bitsensor.plugins", NoLog.class)
        ));

        start();
    }

    @Override
    protected void append(ILoggingEvent event) {
        BitSensor.apply(datapointBuilder ->
                BitSensor.addError(fromILoggingEvent(event)));
    }
}
