package io.bitsensor.plugins.java.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ClassExclusionFilter extends Filter<ILoggingEvent> {

    private Set<Class> classes = new HashSet<>();

    public ClassExclusionFilter(Class clazz) {
        setClassToExclude(clazz);
    }

    public ClassExclusionFilter(Set<Class> classes) {
        setClassesToExclude(classes);
    }

    @Override
    public FilterReply decide(ILoggingEvent event) {
        if (classes.stream().anyMatch(aClass -> event.getLoggerName().contains(aClass.getName())))
            return FilterReply.DENY;
        return FilterReply.NEUTRAL;
    }

    public Set<Class> getClassesToExclude() {
        return classes;
    }

    public void setClassesToExclude(Set<Class> classes) {
        this.classes.addAll(classes);
    }

    public void setClassToExclude(Class clazz) {
        this.classes = Collections.singleton(clazz);
    }
}
