/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.logging.logging;

import io.bitsensor.lib.entity.proto.Error;
import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.logging.NoLog;
import io.bitsensor.plugins.java.logging.log4j2.EventHelper;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.springframework.stereotype.Component;

@Plugin(name="BitSensor", category="BitSensor", elementType="appender", printObject=true)
@Component
public final class Log4j2Appender
extends AbstractAppender {
    public Log4j2Appender() {
        super("BitSensor", (Filter)new AbstractFilter(){

            public Filter.Result filter(LogEvent event) {
                if (!event.getLevel().isMoreSpecificThan(Level.INFO)) {
                    return this.onMismatch;
                }
                try {
                    Class<?> cls = Class.forName(event.getLoggerName());
                    if (cls.isAnnotationPresent(NoLog.class)) {
                        return this.onMismatch;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return this.onMatch;
            }
        }, (Layout)PatternLayout.createDefaultLayout());
    }

    public void append(LogEvent logEvent) {
        BitSensor.addError((Error)EventHelper.fromLoggingEvent(logEvent));
    }
}

