package io.bitsensor.plugins.java.logging.logging;

import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.logging.NoLog;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.springframework.stereotype.Component;

import static io.bitsensor.plugins.java.logging.log4j2.EventHelper.fromLoggingEvent;

@Plugin(name = "BitSensor",
        category = "BitSensor",
        elementType = "appender",
        printObject = true)
@Component
public final class Log4j2Appender extends AbstractAppender {

    public Log4j2Appender() {
        super("BitSensor",
                new AbstractFilter() {
                    @Override
                    public Result filter(LogEvent event) {
                        if (!event.getLevel().isMoreSpecificThan(Level.INFO))
                            return onMismatch;

                        try {
                            Class<?> cls = Class.forName(event.getLoggerName());
                            if (cls.isAnnotationPresent(NoLog.class))
                                return onMismatch;
                        } catch (ClassNotFoundException ignored) {
                        }
                        return onMatch;
                    }
                },
                PatternLayout.createDefaultLayout());
    }

    @Override
    public void append(LogEvent logEvent) {
        BitSensor.addError(fromLoggingEvent(logEvent));
    }
}
