package io.bitsensor.plugins.java.logging.log4j2;


import io.bitsensor.lib.entity.proto.Error;
import io.bitsensor.lib.entity.proto.GeneratedBy;
import org.apache.logging.log4j.core.LogEvent;

public class EventHelper {

    public static Error fromLoggingEvent(LogEvent log) {
        Error.Builder error = Error.newBuilder()
                .setGeneratedBy(GeneratedBy.PLUGIN)
                .setType(log.getLevel().toString())
                .setCode(log.getLevel().intLevel());

        String description = log.getMessage().getFormattedMessage();
        if(description != null)
            error.setDescription(description);


        if(log.getSource() != null) {
            error.setLocation(log.getSource().getClassName());
            error.setLine(log.getSource().getLineNumber());
        }

        return error.build();
    }
}
