/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.logging.logging;

import io.bitsensor.lib.entity.proto.Error;
import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.logging.NoLog;
import io.bitsensor.plugins.java.logging.log4j2.EventHelper;
import java.io.Serializable;
import javax.inject.Named;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="BitSensor", category="BitSensor", elementType="appender", printObject=true)
@Named
public final class Log4j2Appender
extends AbstractAppender {
    public Log4j2Appender() {
        super("BitSensor", (Filter)new AbstractFilter(){

            public Filter.Result filter(LogEvent event) {
                try {
                    Class<?> cls = Class.forName(event.getSource().getClassName());
                    if (cls.isAnnotationPresent(NoLog.class)) {
                        return Filter.Result.DENY;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return Filter.Result.NEUTRAL;
            }
        }, (Layout)PatternLayout.createDefaultLayout());
    }

    protected Log4j2Appender(String name, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, layout);
    }

    public void append(LogEvent logEvent) {
        BitSensor.apply(datapointBuilder -> BitSensor.addError((Error)EventHelper.fromLoggingEvent(logEvent)));
    }
}

