package io.bitsensor.plugins.java.logging.logging;

import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.logging.NoLog;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;

import javax.inject.Named;
import java.io.Serializable;

import static io.bitsensor.plugins.java.logging.log4j2.EventHelper.fromLoggingEvent;

@Plugin(name = "BitSensor",
        category = "BitSensor",
        elementType = "appender",
        printObject = true)
@Named
public final class Log4j2Appender extends AbstractAppender {

    public Log4j2Appender() {
        super("BitSensor",
                new AbstractFilter() {
                    @Override
                    public Result filter(LogEvent event) {
                        try {
                            Class<?> cls = Class.forName(event.getSource().getClassName());

                            if (cls.isAnnotationPresent(NoLog.class))
                                return Result.DENY;
                        } catch (ClassNotFoundException ignored) {
                        }
                        return Result.NEUTRAL;
                    }
                },
                PatternLayout.createDefaultLayout());
    }

    protected Log4j2Appender(String name, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, layout);
    }

    @Override
    public void append(LogEvent logEvent) {
        BitSensor.apply(datapointBuilder ->
                BitSensor.addError(fromLoggingEvent(logEvent)));
    }
}