package io.bitsensor.plugins.java.logging.log4j;


import io.bitsensor.lib.entity.proto.Error;
import io.bitsensor.lib.entity.proto.GeneratedBy;
import org.apache.log4j.spi.LoggingEvent;

public class EventHelper {

    public static Error fromLoggingEvent(LoggingEvent log) {
        Error.Builder error = Error.newBuilder()
                .setGeneratedBy(GeneratedBy.PLUGIN)
                .setType(log.getLevel().toString())
                .setLocation(log.getLocationInformation().getClassName())
                .setLine(parseWithDefault(log.getLocationInformation().getLineNumber(), 0))
                .setCode(log.getLevel().toInt());

        String description = log.getRenderedMessage();
        if (description != null)
            error.setDescription(description);

        return error.build();
    }

    private static int parseWithDefault(String number, int defaultVal) {
        try {
            return Integer.parseInt(number);
        } catch (NumberFormatException e) { //also swallows null
            return defaultVal;
        }
    }
}
