package io.bitsensor.plugins.java.logging.logging;

import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.logging.NoLog;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.springframework.stereotype.Component;

import static io.bitsensor.plugins.java.logging.log4j.EventHelper.fromLoggingEvent;

@Component
public class Log4jAppender extends AppenderSkeleton {

    public Log4jAppender() {
        setName("BitSensor Log4j Appender");
        this.setThreshold(Level.INFO);
        this.addFilter(new Filter() {
            @Override
            public int decide(LoggingEvent event) {
                try {
                    Class<?> cls = Class.forName(event.getLoggerName());

                    if (cls.isAnnotationPresent(NoLog.class))
                        return Filter.DENY;
                } catch (ClassNotFoundException ignored) {
                }
                return Filter.NEUTRAL;
            }
        });
    }

    @Override
    protected void append(LoggingEvent event) {
        BitSensor.addError(fromLoggingEvent(event));
    }

    @Override
    public void close() {
    }

    @Override
    public boolean requiresLayout() {
        return false;
    }
}
