/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.logging.logging;

import io.bitsensor.lib.entity.proto.Error;
import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.logging.NoLog;
import io.bitsensor.plugins.java.logging.log4j.EventHelper;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.springframework.stereotype.Component;

@Component
public class Log4jAppender
extends AppenderSkeleton {
    public Log4jAppender() {
        this.setName("BitSensor Log4j Appender");
        this.addFilter(new Filter(){

            public int decide(LoggingEvent event) {
                try {
                    Class<?> cls = Class.forName(event.getLocationInformation().getClassName());
                    if (cls.isAnnotationPresent(NoLog.class)) {
                        return -1;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return 0;
            }
        });
    }

    protected void append(LoggingEvent event) {
        BitSensor.apply(datapointBuilder -> BitSensor.addError((Error)EventHelper.fromLoggingEvent(event)));
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

