package io.bitsensor.plugins.java.logging.log4j;


import io.bitsensor.lib.entity.proto.Error;
import io.bitsensor.lib.entity.proto.GeneratedBy;
import org.apache.log4j.spi.LoggingEvent;

public class EventHelper {

    public static Error fromLoggingEvent(LoggingEvent log) {
        String description = log.getRenderedMessage();
        String location = log.getLocationInformation().getClassName();
        int line = parseWithDefault(log.getLocationInformation().getLineNumber(), 0);
        int code = log.getLevel().toInt();

        return Error.newBuilder()
                .setGeneratedby(GeneratedBy.PLUGIN)
                .setCode(code)
                .setDescription(description)
                .setLocation(location)
                .setLine(line)
                .setType(log.getLevel().toString())
                .build();

    }

    private static int parseWithDefault(String number, int defaultVal) {
        try {
            return Integer.parseInt(number);
        } catch (NumberFormatException e) {
            return defaultVal;
        }
    }
}
