/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.logging;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class ClassExclusionFilter
extends Filter {
    private Set<Class> classes = new HashSet<Class>();

    public ClassExclusionFilter(Class clazz) {
        this.setClassToExclude(clazz);
    }

    public ClassExclusionFilter(Set<Class> classes) {
        this.setClassesToExclude(classes);
    }

    public int decide(LoggingEvent event) {
        if (this.classes.stream().anyMatch(aClass -> event.getLocationInformation().getClassName().contains(aClass.getName()))) {
            return -1;
        }
        return 0;
    }

    public Set<Class> getClassesToExclude() {
        return this.classes;
    }

    public void setClassesToExclude(Set<Class> classes) {
        this.classes.addAll(classes);
    }

    public void setClassToExclude(Class clazz) {
        this.classes = Collections.singleton(clazz);
    }
}

