package io.bitsensor.plugins.java.logging.logging;

import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.logging.NoLog;
import io.bitsensor.plugins.java.core.util.ComponentScanUtil;
import io.bitsensor.plugins.java.logging.ClassExclusionFilter;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

import javax.inject.Named;

import static io.bitsensor.plugins.java.logging.log4j.EventHelper.fromLoggingEvent;

@Named
public class Log4jAppender extends AppenderSkeleton {

    public Log4jAppender() {
        setName("BitSensor Log4j Appender");
        this.addFilter(new ClassExclusionFilter(
                ComponentScanUtil.scanClassesWithAnnotation("io.bitsensor.plugins", NoLog.class)));
    }

    @Override
    protected void append(LoggingEvent event) {
        BitSensor.apply(datapointBuilder ->
                BitSensor.addError(fromLoggingEvent(event)));
    }

    @Override
    public void close() {

    }

    @Override
    public boolean requiresLayout() {
        return false;
    }
}
