package io.bitsensor.plugins.java.logging;

import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ClassExclusionFilter extends Filter {

    private Set<Class> classes = new HashSet<>();

    public ClassExclusionFilter(Class clazz) {
        setClassToExclude(clazz);
    }

    public ClassExclusionFilter(Set<Class> classes) {
        setClassesToExclude(classes);
    }

    @Override
    public int decide(LoggingEvent event) {
        if (classes.stream().anyMatch(aClass -> event.getLocationInformation().getClassName().contains(aClass.getName())))
            return Filter.DENY;
        return Filter.NEUTRAL;
    }

    public Set<Class> getClassesToExclude() {
        return classes;
    }

    public void setClassesToExclude(Set<Class> classes) {
        this.classes.addAll(classes);
    }

    public void setClassToExclude(Class clazz) {
        this.classes = Collections.singleton(clazz);
    }
}
