package io.bitsensor.plugins.java.web.jaxrs;

import io.bitsensor.plugins.java.http.configuration.BitSensorMethodInvocation;
import io.bitsensor.plugins.java.http.configuration.HttpMessageConverterReadInterceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

/**
 * BitSensor's implementation of JAX-RS abstractions {@link MessageBodyReader} needed for collecting object embedded in
 * POST request body.
 */
@Provider
@Consumes({MediaType.APPLICATION_JSON, "text/json",
        MediaType.APPLICATION_XML, "text/xml"})
public class BitSensorMessageBodyReader implements MessageBodyReader {

    @Context
    Providers providers;

    private MessageBodyReader mbr;

    private MethodInterceptor methodInterceptor = new HttpMessageConverterReadInterceptor();

    @Override
    public boolean isReadable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        mbr = (MessageBodyReader) providers.getMessageBodyWriter(type, genericType, annotations, mediaType);

        return mbr.isReadable(type, genericType, annotations, mediaType);
    }

    @Override
    public Object readFrom(Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        MethodInvocation methodInvocation = new BitSensorMethodInvocation() {
            @Override
            public Object proceed() throws Throwable {
                return mbr.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
            }
        };

        try {
            return methodInterceptor.invoke(methodInvocation);
        } catch (Throwable throwable) {
            throwable.printStackTrace();
        }

        return null;
    }
}
