package io.bitsensor.plugins.java.web.jaxrs;

import io.bitsensor.plugins.java.core.BitSensor;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

/**
 * A BitSensor's implementation of JAX-RS abstractions {@link ExceptionMapper} for collecting exception thrown by the
 * application.
 */
@Provider
public class BitSensorExceptionResolver implements ExceptionMapper<Throwable> {

    @Override
    public Response toResponse(Throwable exception) {
        BitSensor.apply(datapointBuilder -> BitSensor.addThrowable(exception));

        if (exception instanceof WebApplicationException) {
            return ((WebApplicationException) exception).getResponse();
        }

        throw new WebApplicationException(exception);
    }
}
