package io.bitsensor.plugins.java.testing;

import com.github.mjeanroy.junit.servers.tomcat.EmbeddedTomcat;
import com.github.mjeanroy.junit.servers.tomcat.EmbeddedTomcatConfiguration;
import org.junit.AfterClass;
import org.junit.BeforeClass;

import static org.junit.Assert.assertTrue;


public abstract class AbstractTomcatContainer {

    protected static EmbeddedTomcat tomcat;

    protected static String getBaseUri() {
        return "http://localhost:" + tomcat.getPort();
    }

    @BeforeClass
    public static void startContainer() throws Exception {
        EmbeddedTomcatConfiguration configuration = EmbeddedTomcatConfiguration.builder()
                .withPath("/")
                .withWebapp("src/main/webapp")
                .withClasspath("target/classes")
                .withBaseDir("target")
                .build();

        tomcat = new EmbeddedTomcat(configuration);
        tomcat.start();
        assertTrue(tomcat.isStarted());
    }

    @AfterClass
    public static void stopContainer() {
        tomcat.stop();
    }

}
