/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.testing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.servlets.DefaultServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class LogController {
    private Server server;
    public List<String> inputs = Collections.synchronizedList(new ArrayList());
    public CountDownLatch latch = new CountDownLatch(1);

    public void initServer(int port) {
        this.server = new Server(port);
        ServletContextHandler context = new ServletContextHandler();
        ServletHolder defaultServ = new ServletHolder("default", DefaultServlet.class);
        defaultServ.setInitParameter("resourceBase", System.getProperty("user.dir"));
        defaultServ.setInitParameter("dirAllowed", "true");
        this.server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new MockEndPointServletHandler()), "/log");
    }

    public boolean isInitialized() {
        return this.server != null;
    }

    public void startServer() throws Exception {
        if (!this.isInitialized()) {
            throw new RuntimeException("Log server not initialized. Did you forget to call [initServer(PORT)]?");
        }
        this.server.start();
    }

    public void stopServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private class MockEndPointServletHandler
    extends HttpServlet {
        private MockEndPointServletHandler() {
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String body = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            LogController.this.inputs.add(body);
            LogController.this.latch.countDown();
            response.setStatus(202);
        }
    }
}

