package io.bitsensor.plugins.java.testing;

import org.apache.catalina.servlets.DefaultServlet;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;


public class LogController {

    private Server server;
    public List<String> inputs = Collections.synchronizedList(new ArrayList<>());
    public CountDownLatch latch = new CountDownLatch(1);

    public void initServer(int port) {
        server = new Server(port);
        ServletContextHandler context = new ServletContextHandler();
        ServletHolder defaultServ = new ServletHolder("default", DefaultServlet.class);
        defaultServ.setInitParameter("resourceBase", System.getProperty("user.dir"));
        defaultServ.setInitParameter("dirAllowed", "true");
        server.setHandler(context);
        context.addServlet(new ServletHolder(new MockEndPointServletHandler()), "/log");
    }

    public boolean isInitialized() {
        return server != null;
    }

    public void startServer() throws Exception {
        if (!isInitialized()) {
            throw new RuntimeException("Log server not initialized. Did you forget to call [initServer(PORT)]?");
        }
        server.start();
    }

    public void stopServer() throws Exception {
        if (server != null)
            server.stop();
    }

    private class MockEndPointServletHandler extends HttpServlet {

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String body = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            inputs.add(body);
            latch.countDown();
            response.setStatus(HttpServletResponse.SC_ACCEPTED);
        }
    }

}