/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.testing;

import io.bitsensor.lib.entity.proto.Datapoint;
import io.bitsensor.lib.entity.proto.DatapointReceiverGrpc;
import io.bitsensor.lib.entity.proto.Reply;
import io.bitsensor.proto.shaded.io.grpc.BindableService;
import io.bitsensor.proto.shaded.io.grpc.Server;
import io.bitsensor.proto.shaded.io.grpc.ServerBuilder;
import io.bitsensor.proto.shaded.io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class ProtoServer {
    private final Server server;
    public List<Datapoint> receivedDatapoints = new ArrayList<Datapoint>();
    public CountDownLatch latch = new CountDownLatch(1);

    public ProtoServer() {
        this.server = this.buildServer(ServerBuilder.forPort((int)50112));
    }

    public void start() throws IOException {
        this.server.start();
    }

    public void stop() {
        if (this.server == null) {
            return;
        }
        this.server.shutdownNow();
    }

    private Server buildServer(ServerBuilder<?> serverBuilder) {
        return serverBuilder.addService((BindableService)new DatapointReceiverImpl()).build();
    }

    public class DatapointReceiverImpl
    extends DatapointReceiverGrpc.DatapointReceiverImplBase {
        final Reply REPLY = Reply.newBuilder().setMessage("Received").build();

        public void receiveDatapoint(Datapoint request, StreamObserver<Reply> responseObserver) {
            responseObserver.onNext((Object)this.REPLY);
            ProtoServer.this.receivedDatapoints.add(request);
            ProtoServer.this.latch.countDown();
            responseObserver.onCompleted();
        }
    }
}

