package io.bitsensor.plugins.java.testing;

import io.bitsensor.lib.entity.proto.Datapoint;
import io.bitsensor.lib.entity.proto.DatapointReceiverGrpc;
import io.bitsensor.lib.entity.proto.Reply;
import io.bitsensor.proto.shaded.io.grpc.Server;
import io.bitsensor.proto.shaded.io.grpc.ServerBuilder;
import io.bitsensor.proto.shaded.io.grpc.stub.StreamObserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class ProtoServer {

    private final Server server;

    public List<Datapoint> receivedDatapoints = new ArrayList<>();
    public CountDownLatch latch = new CountDownLatch(1);

    public ProtoServer() {
        server = buildServer(ServerBuilder.forPort(50112));
    }

    public void start() throws IOException {
        server.start();
    }

    public void stop() {
        if (server == null) {
            return;
        }

        server.shutdownNow();
    }

    private Server buildServer(ServerBuilder<?> serverBuilder) {
        return serverBuilder.addService(new DatapointReceiverImpl()).build();
    }

    public class DatapointReceiverImpl extends DatapointReceiverGrpc.DatapointReceiverImplBase {
        final Reply REPLY = Reply
                .newBuilder()
                .setMessage("Received")
                .build();

        @Override
        public void receiveDatapoint(Datapoint request, StreamObserver<Reply> responseObserver) {
            responseObserver.onNext(REPLY);
            receivedDatapoints.add(request);
            latch.countDown();
            responseObserver.onCompleted();
        }
    }
}
