/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.testing;

import io.bitsensor.lib.entity.proto.Datapoint;
import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.BitSensorApplication;
import io.bitsensor.plugins.java.core.connectors.ApiConnector;
import io.bitsensor.plugins.java.core.connectors.SampleConnectorConfig;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@ContextConfiguration(classes={BitSensorApplication.class, SampleConnectorConfig.class})
public class CollectorTestService {
    @Autowired
    BitSensor bitSensor;
    @Autowired
    protected ApiConnector connector;
    protected SampleConnectorConfig.CollectingConnector collector;

    @PostConstruct
    public void setup() {
        MatcherAssert.assertThat((Object)this.connector, (Matcher)CoreMatchers.instanceOf(SampleConnectorConfig.CollectingConnector.class));
        this.collector = (SampleConnectorConfig.CollectingConnector)this.connector;
    }

    @Before
    public void clear() {
        this.collector.getQueue().clear();
        BitSensor.initialize();
    }

    protected Collection<Datapoint> getQueue() {
        ArrayList<Datapoint> datapoints = new ArrayList<Datapoint>();
        for (Datapoint.Builder builder : this.collector.getQueue()) {
            datapoints.add(builder.build());
        }
        return datapoints;
    }

    @Test
    public void _empty() {
    }
}

