package io.bitsensor.plugins.java.testing;

import io.bitsensor.lib.entity.proto.Datapoint;
import io.bitsensor.lib.entity.proto.Datapoint.Builder;
import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.BitSensorApplication;
import io.bitsensor.plugins.java.core.connectors.ApiConnector;
import io.bitsensor.plugins.java.core.connectors.SampleConnectorConfig;
import io.bitsensor.plugins.java.core.connectors.SampleConnectorConfig.CollectingConnector;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.PostConstruct;
import java.util.Collection;
import java.util.stream.Collectors;

import static org.hamcrest.CoreMatchers.instanceOf;
import static org.hamcrest.MatcherAssert.assertThat;

@RunWith(SpringRunner.class)
@ContextConfiguration(classes = {BitSensorApplication.class, SampleConnectorConfig.class})
public class CollectorTestService {

    @Autowired
    BitSensor bitSensor;

    @Autowired
    protected ApiConnector connector;

    protected CollectingConnector collector;

    @PostConstruct
    public void setup() {
        assertThat(connector, instanceOf(CollectingConnector.class));
        collector = (CollectingConnector) connector;
    }

    @Before
    public void clear() {
        collector.getQueue().clear();
    }

    /**
     * Returns a collection of {@code Datapoint} added to the collector's {@code queue}
     *
     * @return a collection of {@code Datapoint}
     */
    protected Collection<Datapoint> getQueue() {
        return collector.getQueue().stream()
                .map(Builder::build)
                .collect(Collectors.toSet());
    }

    @Test
    public void _empty() {
    }
}
