package io.bitsensor.plugins.java.http.listener;

import io.bitsensor.plugins.java.core.BitSensorDI;
import io.bitsensor.plugins.java.core.connectors.ApiConnector;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * Listener to startup and shutdown the web application's BitSensor plugin.
 *
 * @see io.bitsensor.plugins.java.http.filter.BitSensorFilter BitSensorFilter
 */
public class BitSensorServletContextListener implements ServletContextListener {

    @Override
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        BitSensorDI.getBean(ApiConnector.class).initialize();
    }

    @Override
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        BitSensorDI.destroy();
    }
}
