package io.bitsensor.plugins.java.http.filter.handler;

import io.bitsensor.plugins.java.core.handler.Handler;
import io.bitsensor.plugins.java.core.handler.HandlerManager;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Contains the data collection handlers for HTTP requests.
 */
@Component
public class RequestHandlerManager extends HandlerManager<RequestHandler> implements HttpInvocationHandler {

    /**
     * {@inheritDoc}
     */
    @Override
    public void preHandle(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null)
            return;

        for (RequestHandler handler : getHandlers()) {
            if (handler.getExecutionMoment() == Handler.ExecutionMoment.PRE_HANDLE)
                handler.handle(request, response);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null)
            return;
        
        for (RequestHandler handler : getHandlers()) {
            if (handler.getExecutionMoment() == Handler.ExecutionMoment.POST_HANDLE)
                handler.handle(request, response);
        }
    }
}
