/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.http.filter.handler;

import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.handler.Handler;
import io.bitsensor.plugins.java.http.filter.handler.RequestHandler;
import io.bitsensor.proto.shaded.com.google.common.collect.ImmutableMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;

@Component
public class HttpRequestHandler
implements RequestHandler {
    private static final Map<String, String> headerNames = HttpRequestHandler.createHeaderNames();

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) {
        if (request.getDispatcherType().equals((Object)DispatcherType.REQUEST)) {
            BitSensor.addContext((String)"http.version", (String)request.getProtocol());
            BitSensor.addContext((String)"http.query", (String)request.getQueryString());
            BitSensor.addContext((String)"http.type", (String)request.getMethod());
            BitSensor.addContext((String)"http.pathInfo", (String)request.getPathInfo());
            BitSensor.addContext((String)"http.https", (String)Boolean.toString(request.isSecure()));
            BitSensor.addContext((String)"authentication.type", (String)request.getAuthType());
            BitSensor.addContext((String)"authentication.user", (String)request.getRemoteUser());
            Enumeration headers = request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                String value = request.getHeader(header);
                if (headerNames.containsKey(header)) {
                    header = headerNames.get(header);
                }
                BitSensor.addContext((String)("http." + header), (String)value);
            }
            BitSensor.addEndpoint((String)"address", (String)request.getLocalAddr());
            BitSensor.addEndpoint((String)"name", (String)request.getHeader("Host"));
            BitSensor.addEndpoint((String)"software", (String)request.getServletContext().getServerInfo());
            BitSensor.addEndpoint((String)"port", (String)Integer.toString(request.getServerPort()));
            BitSensor.addEndpoint((String)"uri", (String)request.getRequestURI());
        } else if (request.getDispatcherType().equals((Object)DispatcherType.FORWARD)) {
            BitSensor.addEndpoint((String)"forward.uri", (String)request.getRequestURI());
        }
    }

    public Handler.ExecutionMoment getExecutionMoment() {
        return Handler.ExecutionMoment.PRE_HANDLE;
    }

    private static Map<String, String> createHeaderNames() {
        HashMap<String, String> headerNames = new HashMap<String, String>();
        headerNames.put("user-agent", "userAgent");
        headerNames.put("accept", "acceptMedia");
        headerNames.put("accept-charset", "acceptCharset");
        headerNames.put("accept-encoding", "acceptEncoding");
        headerNames.put("accept-language", "acceptLanguage");
        headerNames.put("content-type", "contentType");
        headerNames.put("content-length", "contentLength");
        headerNames.put("x-forwarded-for", "x_forwarded_for");
        headerNames.put("x-forwarded-proto", "x_forwarded_proto");
        return ImmutableMap.copyOf(headerNames);
    }
}

